/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create((String)"EXTERNAL_ANNO_MARKER");
    @NotNull
    private static final List<PsiFile> NULL_LIST = new ArrayList<PsiFile>(0);
    @NotNull
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotations = new ConcurrentSoftValueHashMap(10, 0.75f, 2);
    protected final PsiManager myPsiManager;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<PsiModifierListOwner, AnnotationData> cache = new ConcurrentMostlySingularMultiMap();
    private final CharTableImpl charTable = new CharTableImpl();
    private final Map<AnnotationData, AnnotationData> annotationDataCache = new WeakKeyWeakValueHashMap();
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> annotationFileToDataAndModStamp = new ConcurrentSoftHashMap();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };

    public BaseExternalAnnotationsManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                BaseExternalAnnotationsManager.this.dropCache();
            }
        }, (Disposable)psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getExternalName"));
        }
        return PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)showParamName, (int)Integer.MAX_VALUE);
    }

    @NotNull
    static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "preferCompiledElement"));
        }
        PsiElement original = element.getOriginalElement();
        PsiModifierListOwner psiModifierListOwner = original instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element;
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "preferCompiledElement"));
        }
        return psiModifierListOwner;
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotation"));
        }
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotation"));
        }
        List<AnnotationData> list = this.collectExternalAnnotations(listOwner);
        AnnotationData data = BaseExternalAnnotationsManager.findByFQN(list, annotationFQN);
        return data == null ? null : data.getAnnotation(this);
    }

    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotationWritable"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotationWritable"));
        }
        List<AnnotationData> map = this.doCollect(listOwner, true);
        return BaseExternalAnnotationsManager.findByFQN(map, annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map, final @NotNull String annotationFQN) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findByFQN"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findByFQN"));
        }
        return (AnnotationData)ContainerUtil.find(map, (Condition)new Condition<AnnotationData>(){

            public boolean value(AnnotationData data) {
                return data.annotationClassFqName.equals(annotationFQN);
            }
        });
    }

    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotations"));
        }
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        return result.isEmpty() ? null : (PsiAnnotation[])ContainerUtil.map2Array(result, (Object[])PsiAnnotation.EMPTY_ARRAY, (Function)new Function<AnnotationData, PsiAnnotation>(){

            public PsiAnnotation fun(AnnotationData data) {
                return data.getAnnotation(BaseExternalAnnotationsManager.this);
            }
        });
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
            }
            return list;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get((Object)listOwner)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list = cached;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
            }
            return list;
        } while (!this.cache.replace((Object)listOwner, (Collection)cached, computed = this.doCollect(listOwner, false)));
        cached = computed;
        List<AnnotationData> list = cached;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "internAnnotationData"));
        }
        Map<AnnotationData, AnnotationData> map = this.annotationDataCache;
        // MONITORENTER : map
        AnnotationData interned = this.annotationDataCache.get(data);
        if (interned == null) {
            this.annotationDataCache.put(data, data);
            interned = data;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map
        if (annotationData != null) return annotationData;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "internAnnotationData"));
    }

    @NotNull
    private MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
        }
        Pair cached = (Pair)this.annotationFileToDataAndModStamp.get(file);
        long fileModificationStamp = file.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
            }
            return mostlySingularMultiMap;
        }
        DataParsingSaxHandler handler = new DataParsingSaxHandler(file);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new StringReader(BaseExternalAnnotationsManager.escapeAttributes(file.getText()))), (DefaultHandler)handler);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Throwable)e);
        }
        Pair pair = Pair.create(handler.getResult(), (Object)file.getModificationStamp());
        this.annotationFileToDataAndModStamp.put(file, (Pair<MostlySingularMultiMap<String, AnnotationData>, Long>)pair);
        MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)pair.first;
        if (mostlySingularMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
        }
        return mostlySingularMultiMap;
    }

    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        LOG.error(text + "; for signature: '" + externalName + "' in the " + file.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "intern"));
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = ((Object)this.charTable.doIntern(annotationFQN)).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "intern"));
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
        }
        List<PsiFile> files = this.findExternalAnnotationsFiles(listOwner);
        if (files == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list;
        }
        SmartList result = new SmartList();
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner, false);
        if (externalName == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list;
        }
        for (PsiFile file : files) {
            if (!file.isValid() || onlyWritable && !file.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file);
            ContainerUtil.addAll((Collection)result, (Iterable)fileData.get((Object)externalName));
        }
        if (result.isEmpty()) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list;
        }
        result.trimToSize();
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
        }
        return smartList;
    }

    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner _listOwner) {
        SmartList result;
        if (_listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotationsFiles"));
        }
        PsiModifierListOwner listOwner = BaseExternalAnnotationsManager.preferCompiledElement(_listOwner);
        PsiFile containingFile = listOwner.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        String packageName = javaFile.getPackageName();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotations.get(virtualFile);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (PsiFile file : files) {
                allValid &= file.isValid();
            }
            if (allValid) {
                return files;
            }
        }
        THashSet possibleAnnotationsXmls = new THashSet();
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(packageName.replace('.', '/') + "/" + "annotations.xml");
            if (ext == null || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationsXmls.add(psiFile);
        }
        if (possibleAnnotationsXmls.isEmpty()) {
            this.myExternalAnnotations.put(virtualFile, NULL_LIST);
            result = null;
        } else {
            result = new SmartList((Collection)possibleAnnotationsXmls);
            Collections.sort(result, new Comparator<PsiFile>(){

                @Override
                public int compare(PsiFile f1, PsiFile f2) {
                    boolean w2;
                    boolean w1 = f1.isWritable();
                    if (w1 == (w2 = f2.isWritable())) {
                        return 0;
                    }
                    return w1 ? -1 : 1;
                }
            });
            this.myExternalAnnotations.put(virtualFile, (List<PsiFile>)result);
        }
        return result;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotations.clear();
        this.annotationFileToDataAndModStamp.clear();
        this.cache.clear();
    }

    @NotNull
    private static String escapeAttributes(@NotNull String invalidXml) {
        if (invalidXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidXml", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "escapeAttributes"));
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "escapeAttributes"));
        }
        return string;
    }

    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        if (annotationFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "deannotate"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "deannotate"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "editExternalAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "editExternalAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "chooseAnnotationsPlace"));
        }
        throw new UnsupportedOperationException();
    }

    protected void cacheExternalAnnotations(@NotNull String packageName, @NotNull PsiFile fromFile, @NotNull List<PsiFile> annotationFiles) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        if (annotationFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFiles", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        VirtualFile virtualFile = fromFile.getVirtualFile();
        if (virtualFile != null) {
            this.myExternalAnnotations.put(virtualFile, annotationFiles);
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "markAsExternalAnnotation"));
        }
        annotation.putUserData(EXTERNAL_ANNO_MARKER, (Object)Boolean.TRUE);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "createAnnotationFromText"));
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "createAnnotationFromText"));
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> data = new MostlySingularMultiMap();
        private final PsiFile file;
        private String externalName = null;
        private String annotationFQN = null;
        private StringBuilder arguments = null;

        private DataParsingSaxHandler(PsiFile file) {
            this.file = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.externalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.annotationFQN = attributes.getValue("name");
                this.arguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.arguments.length() != 0) {
                    this.arguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.arguments.append(name);
                    this.arguments.append("=");
                }
                this.arguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("item".equals(qName)) {
                this.externalName = null;
            } else if ("annotation".equals(qName) && this.externalName != null && this.annotationFQN != null) {
                String argumentsString = this.arguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.arguments.toString());
                for (AnnotationData existingData : this.data.get((Object)this.externalName)) {
                    if (!existingData.annotationClassFqName.equals(this.annotationFQN)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.file, this.externalName, "Duplicate annotation '" + this.annotationFQN + "' ");
                }
                AnnotationData annData = BaseExternalAnnotationsManager.this.internAnnotationData(new AnnotationData(this.annotationFQN, argumentsString));
                this.data.add((Object)this.externalName, (Object)annData);
                this.annotationFQN = null;
                this.arguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.data.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.data.compact();
            return this.data;
        }
    }

    private static class AnnotationData {
        @NotNull
        private final String annotationClassFqName;
        @NotNull
        private final String annotationParameters;
        private volatile PsiAnnotation annotation;

        private AnnotationData(@NotNull String annotationClassFqName, @NotNull String annotationParameters) {
            if (annotationClassFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassFqName", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "<init>"));
            }
            if (annotationParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParameters", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "<init>"));
            }
            this.annotationClassFqName = annotationClassFqName;
            this.annotationParameters = annotationParameters;
        }

        @NotNull
        private PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "getAnnotation"));
            }
            PsiAnnotation a = this.annotation;
            if (a == null) {
                a = context.createAnnotationFromText("@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")"));
                this.annotation = BaseExternalAnnotationsManager.markAsExternalAnnotation(a);
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "getAnnotation"));
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters);
        }

        public int hashCode() {
            int result = this.annotationClassFqName.hashCode();
            result = 31 * result + this.annotationParameters.hashCode();
            return result;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }
    }
}

