/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsHighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil");
    private static final ElementPattern<PsiElement> ANY_ANNOTATION_ALLOWED = PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiNameValuePair.class}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiAnnotationMethod.class}), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiAnnotationMethod.class)).afterLeaf(new String[]{"default"})});

    @Nullable
    public static HighlightInfo checkNameValuePair(PsiNameValuePair pair) {
        PsiReference ref = pair.getReference();
        if (ref == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)ref.resolve();
        if (method == null) {
            if (pair.getName() != null) {
                String description = JavaErrorMessages.message("annotation.unknown.method", ref.getCanonicalText());
                PsiElement element = ref.getElement();
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(element).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateAnnotationMethodFromUsageFix(pair));
                return highlightInfo;
            }
            String description = JavaErrorMessages.message("annotation.missing.method", ref.getCanonicalText());
            PsiElement element = ref.getElement();
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
        }
        PsiType returnType = method.getReturnType();
        assert (returnType != null) : method;
        PsiAnnotationMemberValue value = pair.getValue();
        HighlightInfo info = AnnotationsHighlightUtil.checkMemberValueType(value, returnType);
        if (info != null) {
            return info;
        }
        return AnnotationsHighlightUtil.checkDuplicateAttribute(pair);
    }

    @Nullable
    private static HighlightInfo checkDuplicateAttribute(PsiNameValuePair pair) {
        PsiNameValuePair[] attributes;
        PsiAnnotationParameterList annotation = (PsiAnnotationParameterList)pair.getParent();
        for (PsiNameValuePair attribute : attributes = annotation.getAttributes()) {
            if (attribute == pair) break;
            String name = pair.getName();
            if (!Comparing.equal((String)attribute.getName(), (String)name)) continue;
            String description = JavaErrorMessages.message("annotation.duplicate.attribute", name == null ? "value" : name);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)pair).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static String formatReference(PsiJavaCodeReferenceElement ref) {
        return ref.getCanonicalText();
    }

    @Nullable
    public static HighlightInfo checkMemberValueType(@Nullable PsiAnnotationMemberValue value, PsiType expectedType) {
        if (value == null) {
            return null;
        }
        if (expectedType instanceof PsiClassType && expectedType.equalsToText("java.lang.Class") && !(value instanceof PsiClassObjectAccessExpression)) {
            String description = JavaErrorMessages.message("annotation.non.class.literal.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)value).descriptionAndTooltip(description).create();
        }
        if (value instanceof PsiAnnotation) {
            PsiClass aClass;
            PsiType componentType;
            PsiClass aClass2;
            PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value).getNameReferenceElement();
            if (nameRef == null) {
                return null;
            }
            if (expectedType instanceof PsiClassType && (aClass2 = ((PsiClassType)expectedType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass2)) {
                return null;
            }
            if (expectedType instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && (aClass = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass)) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.incompatible.types", AnnotationsHighlightUtil.formatReference(nameRef), JavaHighlightUtil.formatType(expectedType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)value).descriptionAndTooltip(description).create();
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            if (expectedType instanceof PsiArrayType) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.illegal.array.initializer", JavaHighlightUtil.formatType(expectedType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)value).descriptionAndTooltip(description).create();
        }
        if (value instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)value;
            PsiType type = expr.getType();
            if (type != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expr) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)((PsiArrayType)expectedType).getComponentType(), (PsiExpression)expr)) {
                return null;
            }
            String description = JavaErrorMessages.message("annotation.incompatible.types", JavaHighlightUtil.formatType(type), JavaHighlightUtil.formatType(expectedType));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)value).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createSurroundWithQuotesAnnotationParameterValueFix(value, expectedType));
            return info;
        }
        LOG.error("Unknown annotation member value: " + value);
        return null;
    }

    static HighlightInfo checkDuplicateAnnotations(@NotNull PsiAnnotation annotationToCheck, @NotNull LanguageLevel languageLevel) {
        String containedElementFQN;
        if (annotationToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationToCheck", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkDuplicateAnnotations"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkDuplicateAnnotations"));
        }
        PsiAnnotationOwner owner = annotationToCheck.getOwner();
        if (owner == null) {
            return null;
        }
        PsiJavaCodeReferenceElement element = annotationToCheck.getNameReferenceElement();
        if (element == null) {
            return null;
        }
        PsiElement resolved = element.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiClass contained = AnnotationsHighlightUtil.contained(annotationType);
        String string = containedElementFQN = contained == null ? null : contained.getQualifiedName();
        if (containedElementFQN != null) {
            PsiClass container = annotationType;
            String containerName = container.getQualifiedName();
            if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner, containedElementFQN)) {
                String description = JavaErrorMessages.message("annotation.container.wrong.place", containerName);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, description);
            }
        } else if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner, annotationType.getQualifiedName())) {
            PsiAnnotation.TargetType[] targets;
            PsiAnnotation.TargetType applicable;
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                String description = JavaErrorMessages.message("annotation.duplicate.annotation", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            PsiAnnotation metaAnno = PsiImplUtil.findAnnotation((PsiAnnotationOwner)annotationType.getModifierList(), "java.lang.annotation.Repeatable");
            if (metaAnno == null) {
                String explanation = JavaErrorMessages.message("annotation.non.repeatable", annotationType.getQualifiedName());
                String description = JavaErrorMessages.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            String explanation = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(metaAnno);
            if (explanation != null) {
                String description = JavaErrorMessages.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            PsiClass container = AnnotationsHighlightUtil.getRepeatableContainer(metaAnno);
            if (container != null && (applicable = PsiImplUtil.findApplicableTarget(container, targets = PsiImplUtil.getTargetsForLocation(owner))) == null) {
                String target = JavaErrorMessages.message("annotation.target." + targets[0], new Object[0]);
                String message = JavaErrorMessages.message("annotation.container.not.applicable", container.getName(), target);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, message);
            }
        }
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            PsiElement aClass;
            PsiJavaCodeReferenceElement nameRef;
            if (annotation != annotationToCheck && (nameRef = annotation.getNameReferenceElement()) != null && resolved.equals(aClass = nameRef.resolve())) continue;
        }
        return null;
    }

    private static PsiClass contained(PsiClass annotationType) {
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiMethod[] values = annotationType.findMethodsByName("value", false);
        if (values.length != 1) {
            return null;
        }
        PsiMethod value = values[0];
        PsiType returnType = value.getReturnType();
        if (!(returnType instanceof PsiArrayType)) {
            return null;
        }
        PsiType type = ((PsiArrayType)returnType).getComponentType();
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClass contained = ((PsiClassType)type).resolve();
        if (contained == null || !contained.isAnnotationType()) {
            return null;
        }
        if (PsiImplUtil.findAnnotation((PsiAnnotationOwner)contained.getModifierList(), "java.lang.annotation.Repeatable") == null) {
            return null;
        }
        return contained;
    }

    private static boolean isAnnotationRepeatedTwice(@NotNull PsiAnnotationOwner owner, @NotNull String qualifiedName) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "isAnnotationRepeatedTwice"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "isAnnotationRepeatedTwice"));
        }
        int count = 0;
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null || !((resolved = nameRef.resolve()) instanceof PsiClass) || !qualifiedName.equals(((PsiClass)resolved).getQualifiedName()) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static HighlightInfo checkMissingAttributes(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)nameRef.resolve();
        if (aClass != null && aClass.isAnnotationType()) {
            PsiNameValuePair[] attributes;
            HashSet names = new HashSet();
            for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                String name = attribute.getName();
                if (name != null) {
                    names.add(name);
                    continue;
                }
                names.add("value");
            }
            PsiMethod[] annotationMethods = aClass.getMethods();
            ArrayList<String> missed = new ArrayList<String>();
            for (PsiMethod method : annotationMethods) {
                PsiAnnotationMethod annotationMethod;
                if (!PsiUtil.isAnnotationMethod((PsiElement)method) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null || names.contains(annotationMethod.getName())) continue;
                missed.add(annotationMethod.getName());
            }
            if (!missed.isEmpty()) {
                StringBuffer buff = new StringBuffer("'" + (String)missed.get(0) + "'");
                for (int i = 1; i < missed.size(); ++i) {
                    buff.append(", ");
                    buff.append("'").append((String)missed.get(i)).append("'");
                }
                String description = JavaErrorMessages.message("annotation.missing.attribute", buff);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)nameRef).descriptionAndTooltip(description).create();
                IntentionAction fix = QuickFixFactory.getInstance().createAddMissingRequiredAnnotationParametersFix(annotation, annotationMethods, missed);
                QuickFixAction.registerQuickFixAction(info, fix);
                return info;
            }
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkConstantExpression(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if ((PsiUtil.isAnnotationMethod((PsiElement)parent) || parent instanceof PsiNameValuePair || parent instanceof PsiArrayInitializerMemberValue) && !PsiUtil.isConstantExpression((PsiExpression)expression)) {
            String description = JavaErrorMessages.message("annotation.non.constant.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkValidAnnotationType(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (((Boolean)type.accept((PsiTypeVisitor)AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return null;
        }
        String description = JavaErrorMessages.message("annotation.invalid.annotation.member.type", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
    }

    @Nullable
    public static HighlightInfo checkApplicability(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        HighlightInfo info;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkApplicability"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkApplicability"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkApplicability"));
        }
        if (ANY_ANNOTATION_ALLOWED.accepts((Object)annotation)) {
            return null;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiAnnotationOwner owner = annotation.getOwner();
        PsiAnnotation.TargetType[] targets = PsiImplUtil.getTargetsForLocation(owner);
        if (owner == null || targets.length == 0) {
            String message = JavaErrorMessages.message("annotation.not.allowed.here", new Object[0]);
            return AnnotationsHighlightUtil.annotationError(annotation, message);
        }
        if (!(owner instanceof PsiModifierList) && (info = HighlightUtil.checkFeature((PsiElement)annotation, HighlightUtil.Feature.TYPE_ANNOTATIONS, level, file)) != null) {
            return info;
        }
        PsiAnnotation.TargetType applicable = PsiImplUtil.findApplicableTarget(annotation, targets);
        if (applicable == PsiAnnotation.TargetType.UNKNOWN) {
            return null;
        }
        if (applicable == null) {
            String target = JavaErrorMessages.message("annotation.target." + targets[0], new Object[0]);
            String message = JavaErrorMessages.message("annotation.not.applicable", nameRef.getText(), target);
            return AnnotationsHighlightUtil.annotationError(annotation, message);
        }
        if (applicable == PsiAnnotation.TargetType.TYPE_USE) {
            PsiElement context;
            if (owner instanceof PsiClassReferenceType) {
                PsiJavaCodeReferenceElement ref = ((PsiClassReferenceType)owner).getReference();
                HighlightInfo info2 = AnnotationsHighlightUtil.checkReferenceTarget(annotation, ref);
                if (info2 != null) {
                    return info2;
                }
            } else if (owner instanceof PsiModifierList) {
                PsiElement nextElement = PsiTreeUtil.skipSiblingsForward((PsiElement)((PsiModifierList)owner), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class});
                if (nextElement instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement ref;
                    HighlightInfo info3;
                    PsiTypeElement typeElement = (PsiTypeElement)nextElement;
                    PsiType type = typeElement.getType();
                    if (PsiType.VOID.equals((Object)type)) {
                        String message = JavaErrorMessages.message("annotation.not.allowed.void", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation, message);
                    }
                    if (!(type instanceof PsiPrimitiveType) && (info3 = AnnotationsHighlightUtil.checkReferenceTarget(annotation, ref = AnnotationsHighlightUtil.getOutermostReferenceElement(typeElement.getInnermostComponentReferenceElement()))) != null) {
                        return info3;
                    }
                }
            } else if (owner instanceof PsiTypeElement && (context = PsiTreeUtil.skipParentsOfType((PsiElement)((PsiTypeElement)owner), (Class[])new Class[]{PsiTypeElement.class})) instanceof PsiClassObjectAccessExpression) {
                String message = JavaErrorMessages.message("annotation.not.allowed.class", new Object[0]);
                return AnnotationsHighlightUtil.annotationError(annotation, message);
            }
        }
        return null;
    }

    private static HighlightInfo annotationError(PsiAnnotation annotation, String message) {
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(info, new DeleteAnnotationAction(annotation));
        return info;
    }

    @Nullable
    private static HighlightInfo checkReferenceTarget(PsiAnnotation annotation, @Nullable PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            return null;
        }
        PsiElement refTarget = ref.resolve();
        if (refTarget == null) {
            return null;
        }
        String message = null;
        if (!(refTarget instanceof PsiClass)) {
            message = JavaErrorMessages.message("annotation.not.allowed.ref", new Object[0]);
        } else {
            PsiElement qualified;
            PsiElement parent = ref.getParent();
            if (parent instanceof PsiJavaCodeReferenceElement && (qualified = ((PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiMember && ((PsiMember)qualified).hasModifierProperty("static")) {
                message = JavaErrorMessages.message("annotation.not.allowed.static", new Object[0]);
            }
        }
        return message != null ? AnnotationsHighlightUtil.annotationError(annotation, message) : null;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement getOutermostReferenceElement(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement qualifier;
        if (ref == null) {
            return null;
        }
        while ((qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)qualifier;
        }
        return ref;
    }

    public static HighlightInfo checkForeignInnerClassesUsed(PsiAnnotation annotation) {
        PsiElement parent;
        final HighlightInfo[] infos = new HighlightInfo[1];
        PsiAnnotationOwner owner = annotation.getOwner();
        if (owner instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiClass) {
            annotation.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (infos[0] != null) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
                    super.visitClassObjectAccessExpression(expression);
                    PsiTypeElement operand = expression.getOperand();
                    PsiClass classType = PsiUtil.resolveClassInType((PsiType)operand.getType());
                    if (classType != null) {
                        this.checkAccessibility((PsiExpression)expression, (PsiMember)classType, HighlightUtil.formatClass(classType));
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiField) {
                        this.checkAccessibility((PsiExpression)expression, (PsiMember)resolve, HighlightUtil.formatField((PsiField)resolve));
                    }
                }

                private void checkAccessibility(PsiExpression expression, PsiMember resolve, String memberString) {
                    if (resolve.hasModifierProperty("private") && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)resolve, (boolean)true)) {
                        String description = JavaErrorMessages.message("private.symbol", memberString, HighlightUtil.formatClass((PsiClass)parent));
                        infos[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
                    }
                }
            });
        }
        return infos[0];
    }

    @Nullable
    public static HighlightInfo checkAnnotationType(PsiAnnotation annotation) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
        if (!(nameReferenceElement == null || (resolved = nameReferenceElement.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType())) {
            String description = JavaErrorMessages.message("annotation.annotation.type.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)nameReferenceElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkCyclicMemberType(PsiTypeElement typeElement, PsiClass aClass) {
        LOG.assertTrue(aClass.isAnnotationType());
        PsiType type = typeElement.getType();
        HashSet checked = new HashSet();
        if (AnnotationsHighlightUtil.cyclicDependencies(aClass, type, (Set<PsiClass>)checked, aClass.getManager())) {
            String description = JavaErrorMessages.message("annotation.cyclic.element.type", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static boolean cyclicDependencies(PsiClass aClass, PsiType type, @NotNull Set<PsiClass> checked, @NotNull PsiManager manager) {
        if (checked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checked", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "cyclicDependencies"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "cyclicDependencies"));
        }
        PsiClass resolvedClass = PsiUtil.resolveClassInType((PsiType)type);
        if (resolvedClass != null && resolvedClass.isAnnotationType()) {
            PsiMethod[] methods;
            if (aClass == resolvedClass) {
                return true;
            }
            if (!checked.add(resolvedClass) || !manager.isInProject((PsiElement)resolvedClass)) {
                return false;
            }
            for (PsiMethod method : methods = resolvedClass.getMethods()) {
                if (!AnnotationsHighlightUtil.cyclicDependencies(aClass, method.getReturnType(), checked, manager)) continue;
                return true;
            }
        }
        return false;
    }

    public static HighlightInfo checkClashesWithSuperMethods(@NotNull PsiAnnotationMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkClashesWithSuperMethods"));
        }
        PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiMethod.findDeepestSuperMethods()) {
                String qualifiedName;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(qualifiedName = containingClass.getQualifiedName()) && !"java.lang.annotation.Annotation".equals(qualifiedName)) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)nameIdentifier).descriptionAndTooltip("@interface member clashes with '" + JavaHighlightUtil.formatMethod(method) + "' in " + HighlightUtil.formatClass(containingClass)).create();
            }
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkAnnotationDeclaration(PsiElement parent, PsiReferenceList list) {
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            PsiAnnotationMethod method = (PsiAnnotationMethod)parent;
            if (list == method.getThrowsList()) {
                String description = JavaErrorMessages.message("annotation.members.may.not.have.throws.list", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
            }
        } else if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType() && "extends".equals(list.getFirstChild().getText())) {
            String description = JavaErrorMessages.message("annotation.may.not.have.extends.list", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkPackageAnnotationContainingFile(PsiPackageStatement statement) {
        if (statement.getAnnotationList() == null) {
            return null;
        }
        PsiFile file = statement.getContainingFile();
        if (file != null && !"package-info.java".equals(file.getName())) {
            String description = JavaErrorMessages.message("invalid.package.annotation.containing.file", new Object[0]);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR);
            builder.range(statement.getAnnotationList().getTextRange());
            builder.descriptionAndTooltip(description);
            return builder.create();
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkTargetAnnotationDuplicates(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !"java.lang.annotation.Target".equals(((PsiClass)resolved).getQualifiedName())) {
            return null;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length < 1) {
            return null;
        }
        PsiAnnotationMemberValue value = attributes[0].getValue();
        if (!(value instanceof PsiArrayInitializerMemberValue)) {
            return null;
        }
        PsiAnnotationMemberValue[] arrayInitializers = ((PsiArrayInitializerMemberValue)value).getInitializers();
        HashSet targets = new HashSet();
        for (PsiAnnotationMemberValue initializer : arrayInitializers) {
            PsiElement target;
            if (!(initializer instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)initializer).resolve()) == null) continue;
            if (targets.contains(target)) {
                String description = JavaErrorMessages.message("repeated.annotation.target", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)initializer).descriptionAndTooltip(description).create();
            }
            targets.add(target);
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkFunctionalInterface(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel languageLevel) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkFunctionalInterface"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "checkFunctionalInterface"));
        }
        String errorMessage = LambdaUtil.checkFunctionalInterface((PsiAnnotation)annotation, (LanguageLevel)languageLevel);
        if (errorMessage != null) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(errorMessage).create();
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkRepeatableAnnotation(PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef;
        String qualifiedName = annotation.getQualifiedName();
        if (!"java.lang.annotation.Repeatable".equals(qualifiedName)) {
            return null;
        }
        String description = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(annotation);
        if (description != null && (containerRef = PsiImplUtil.findAttributeValue(annotation, null)) != null) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)containerRef).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    private static String doCheckRepeatableAnnotation(@NotNull PsiAnnotation annotation) {
        Set<PsiAnnotation.TargetType> containerTargets;
        RetentionPolicy containerPolicy;
        PsiArrayType expected;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "doCheckRepeatableAnnotation"));
        }
        PsiAnnotationOwner owner = annotation.getOwner();
        if (!(owner instanceof PsiModifierList)) {
            return null;
        }
        PsiElement target = ((PsiModifierList)owner).getParent();
        if (!(target instanceof PsiClass) || !((PsiClass)target).isAnnotationType()) {
            return null;
        }
        PsiClass container = AnnotationsHighlightUtil.getRepeatableContainer(annotation);
        if (container == null) {
            return null;
        }
        PsiMethod[] methods = container.findMethodsByName("value", false);
        if (methods.length == 0) {
            return JavaErrorMessages.message("annotation.container.no.value", container.getQualifiedName());
        }
        if (methods.length == 1 && !(expected = new PsiImmediateClassType((PsiClass)target, PsiSubstitutor.EMPTY).createArrayType()).equals(methods[0].getReturnType())) {
            return JavaErrorMessages.message("annotation.container.bad.type", container.getQualifiedName(), JavaHighlightUtil.formatType((PsiType)expected));
        }
        RetentionPolicy targetPolicy = AnnotationsHighlightUtil.getRetentionPolicy((PsiClass)target);
        if (targetPolicy != null && (containerPolicy = AnnotationsHighlightUtil.getRetentionPolicy(container)) != null && targetPolicy.compareTo(containerPolicy) > 0) {
            return JavaErrorMessages.message("annotation.container.low.retention", new Object[]{container.getQualifiedName(), containerPolicy});
        }
        Set<PsiAnnotation.TargetType> repeatableTargets = PsiImplUtil.getAnnotationTargets((PsiClass)target);
        if (repeatableTargets != null && (containerTargets = PsiImplUtil.getAnnotationTargets(container)) != null && !repeatableTargets.containsAll(containerTargets)) {
            return JavaErrorMessages.message("annotation.container.wide.target", container.getQualifiedName());
        }
        return null;
    }

    @Nullable
    private static PsiClass getRepeatableContainer(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil", "getRepeatableContainer"));
        }
        PsiAnnotationMemberValue containerRef = PsiImplUtil.findAttributeValue(annotation, null);
        if (!(containerRef instanceof PsiClassObjectAccessExpression)) {
            return null;
        }
        PsiType containerType = ((PsiClassObjectAccessExpression)containerRef).getOperand().getType();
        if (!(containerType instanceof PsiClassType)) {
            return null;
        }
        PsiClass container = ((PsiClassType)containerType).resolve();
        if (container == null || !container.isAnnotationType()) {
            return null;
        }
        return container;
    }

    @Nullable
    private static RetentionPolicy getRetentionPolicy(PsiClass annotation) {
        PsiModifierList modifierList = annotation.getModifierList();
        if (modifierList != null) {
            PsiElement field;
            PsiAnnotation retentionAnno = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnno == null) {
                return RetentionPolicy.CLASS;
            }
            PsiAnnotationMemberValue policyRef = PsiImplUtil.findAttributeValue(retentionAnno, null);
            if (policyRef instanceof PsiReference && (field = ((PsiReference)policyRef).resolve()) instanceof PsiEnumConstant) {
                String name = ((PsiEnumConstant)field).getName();
                try {
                    return RetentionPolicy.valueOf(RetentionPolicy.class, name);
                }
                catch (Exception e) {
                    LOG.warn("Unknown policy: " + name);
                }
            }
        }
        return null;
    }

    private static class DeleteAnnotationAction
    implements IntentionAction {
        private final PsiAnnotation myAnnotation;

        public DeleteAnnotationAction(PsiAnnotation annotation) {
            this.myAnnotation = annotation;
        }

        @NotNull
        public String getText() {
            if ("Remove" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction", "getText"));
            }
            return "Remove";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/AnnotationsHighlightUtil$DeleteAnnotationAction", "invoke"));
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            this.myAnnotation.delete();
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    public static class AnnotationReturnTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        public static final AnnotationReturnTypeVisitor INSTANCE = new AnnotationReturnTypeVisitor();

        public Boolean visitType(PsiType type) {
            return Boolean.FALSE;
        }

        public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return PsiType.VOID.equals((Object)primitiveType) || PsiType.NULL.equals((Object)primitiveType) ? Boolean.FALSE : Boolean.TRUE;
        }

        public Boolean visitArrayType(PsiArrayType arrayType) {
            if (arrayType.getArrayDimensions() != 1) {
                return Boolean.FALSE;
            }
            PsiType componentType = arrayType.getComponentType();
            return (Boolean)componentType.accept((PsiTypeVisitor)this);
        }

        public Boolean visitClassType(PsiClassType classType) {
            if (classType.getParameters().length > 0) {
                PsiClassType rawType = classType.rawType();
                return rawType.equalsToText("java.lang.Class");
            }
            PsiClass aClass = classType.resolve();
            if (aClass != null && (aClass.isAnnotationType() || aClass.isEnum())) {
                return Boolean.TRUE;
            }
            return classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String");
        }
    }
}

