/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertToStringLiteralAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("convert.to.string.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertToStringLiteralAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("convert.to.string.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertToStringLiteralAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertToStringLiteralAction", "isAvailable"));
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.CHARACTER_LITERAL);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String text;
        int length;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertToStringLiteralAction", "invoke"));
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.CHARACTER_LITERAL) && (length = (text = StringUtil.unescapeStringCharacters((String)element.getText())).length()) > 1 && text.charAt(0) == '\'' && text.charAt(length - 1) == '\'') {
            String value = StringUtil.escapeStringCharacters((String)text.substring(1, length - 1));
            PsiExpression expression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText('\"' + value + '\"', null);
            PsiElement literal = expression.getFirstChild();
            if (literal != null && PsiUtil.isJavaToken((PsiElement)literal, (IElementType)JavaTokenType.STRING_LITERAL)) {
                element.replace(literal);
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

