/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.codeInsight.template.macro.VariableTypeCalculator;
import com.intellij.codeInsight.template.macro.VariableTypeMacroBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class IterableVariableMacro
extends VariableTypeMacroBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.macro.IterableVariableMacro");

    public String getName() {
        return "iterableVariable";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.iterable.variable", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        PsiVariable[] variables;
        if (params.length != 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Project project = context.getProject();
        int offset = context.getStartOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        assert (file != null);
        PsiElement place = file.findElementAt(offset);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        GlobalSearchScope scope = file.getResolveScope();
        PsiClassType iterableType = elementFactory.createTypeByFQClassName("java.lang.Iterable", scope);
        PsiClassType mapType = elementFactory.createTypeByFQClassName("java.util.Map", scope);
        for (PsiVariable var : variables = MacroUtil.getVariablesVisibleAt(place, "")) {
            PsiElement parent = var.getParent();
            if (parent instanceof PsiForeachStatement && parent == PsiTreeUtil.getParentOfType((PsiElement)place, PsiForeachStatement.class)) continue;
            PsiType type = VariableTypeCalculator.getVarTypeAt(var, place);
            if (type instanceof PsiArrayType || iterableType.isAssignableFrom(type)) {
                result.add(var);
                continue;
            }
            if (!mapType.isAssignableFrom(type)) continue;
            try {
                result.add(elementFactory.createExpressionFromText(var.getName() + ".keySet()", var.getParent()));
                result.add(elementFactory.createExpressionFromText(var.getName() + ".values()", var.getParent()));
                result.add(elementFactory.createExpressionFromText(var.getName() + ".entrySet()", var.getParent()));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return PsiUtilCore.toPsiElementArray(result);
    }
}

