/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ContractChecker
extends DataFlowRunner {
    private final PsiMethod myMethod;
    private final MethodContract myContract;
    private final boolean myOnTheFly;
    private final Set<PsiElement> myViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myNonViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myFailures = ContainerUtil.newHashSet();

    ContractChecker(PsiMethod method, PsiCodeBlock body, MethodContract contract, boolean onTheFly) {
        super((PsiElement)body);
        this.myMethod = method;
        this.myContract = contract;
        this.myOnTheFly = onTheFly;
    }

    static Map<PsiElement, String> checkContractClause(PsiMethod method, MethodContract contract, boolean ignoreAssertions, boolean onTheFly) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return Collections.emptyMap();
        }
        ContractChecker checker = new ContractChecker(method, body, contract, onTheFly);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        DfaMemoryState initialState = checker.createMemoryState();
        DfaValueFactory factory = checker.getFactory();
        for (int i = 0; i < contract.arguments.length; ++i) {
            MethodContract.ValueConstraint constraint = contract.arguments[i];
            DfaConstValue comparisonValue = constraint.getComparisonValue(factory);
            if (comparisonValue == null) continue;
            boolean negated = constraint.shouldUseNonEqComparison();
            DfaVariableValue dfaParam = factory.getVarFactory().createVariableValue((PsiVariable)parameters[i], false);
            initialState.applyCondition(factory.getRelationFactory().createRelation(dfaParam, comparisonValue, JavaTokenType.EQEQ, negated));
        }
        checker.analyzeMethod((PsiElement)body, new StandardInstructionVisitor(), ignoreAssertions, Arrays.asList(initialState));
        return checker.getErrors();
    }

    @Override
    protected boolean shouldCheckTimeLimit() {
        if (!this.myOnTheFly) {
            return false;
        }
        return super.shouldCheckTimeLimit();
    }

    @Override
    protected DfaInstructionState[] acceptInstruction(InstructionVisitor visitor, DfaInstructionState instructionState) {
        DfaMemoryState memState = instructionState.getMemoryState();
        if (memState.isEphemeral()) {
            return DfaInstructionState.EMPTY_ARRAY;
        }
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof CheckReturnValueInstruction) {
            PsiElement anchor = ((CheckReturnValueInstruction)instruction).getReturn();
            DfaValue retValue = memState.pop();
            if (this.breaksContract(retValue, this.myContract.returnValue, memState)) {
                this.myViolations.add(anchor);
            } else {
                this.myNonViolations.add(anchor);
            }
            return InstructionVisitor.nextInstruction(instruction, this, memState);
        }
        if (instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isViaException()) {
            ContainerUtil.addIfNotNull(this.myFailures, (Object)((ReturnInstruction)instruction).getAnchor());
        }
        if (instruction instanceof MethodCallInstruction && ((MethodCallInstruction)instruction).getMethodType() == MethodCallInstruction.MethodType.REGULAR_METHOD_CALL && this.myContract.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
            ContainerUtil.addIfNotNull(this.myFailures, (Object)((MethodCallInstruction)instruction).getCallExpression());
            return DfaInstructionState.EMPTY_ARRAY;
        }
        return super.acceptInstruction(visitor, instructionState);
    }

    private Map<PsiElement, String> getErrors() {
        HashMap errors = ContainerUtil.newHashMap();
        for (PsiElement element : this.myViolations) {
            if (this.myNonViolations.contains(element)) continue;
            errors.put(element, "Contract clause '" + this.myContract + "' is violated");
        }
        if (this.myContract.returnValue != MethodContract.ValueConstraint.THROW_EXCEPTION) {
            for (PsiElement element : this.myFailures) {
                errors.put(element, "Contract clause '" + this.myContract + "' is violated: exception might be thrown instead of returning " + (Object)((Object)this.myContract.returnValue));
            }
        } else if (this.myFailures.isEmpty() && errors.isEmpty()) {
            PsiIdentifier nameIdentifier = this.myMethod.getNameIdentifier();
            errors.put(nameIdentifier != null ? nameIdentifier : this.myMethod, "Contract clause '" + this.myContract + "' is violated: no exception is thrown");
        }
        return errors;
    }

    private boolean breaksContract(DfaValue retValue, MethodContract.ValueConstraint constraint, DfaMemoryState state) {
        switch (constraint) {
            case NULL_VALUE: {
                return state.isNotNull(retValue);
            }
            case NOT_NULL_VALUE: {
                return state.isNull(retValue);
            }
            case TRUE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getFalse(), state);
            }
            case FALSE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getTrue(), state);
            }
            case THROW_EXCEPTION: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEquivalentTo(DfaValue val, DfaConstValue constValue, DfaMemoryState state) {
        return val == constValue || val instanceof DfaVariableValue && constValue == state.getConstantValue((DfaVariableValue)val);
    }
}

