/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inconsistentLanguageLevel;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyInspection;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InconsistentLanguageLevelInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return false;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "runInspection"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "runInspection"));
        }
        if (problemProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemProcessor", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "runInspection"));
        }
        THashSet modules = new THashSet();
        scope.accept(new PsiElementVisitor((Set)modules){
            final /* synthetic */ Set val$modules;
            {
                this.val$modules = set;
            }

            public void visitElement(PsiElement element) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module != null) {
                    this.val$modules.add(module);
                }
            }
        });
        LanguageLevel projectLanguageLevel = LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel();
        for (Module module : modules) {
            LanguageLevel languageLevel = LanguageLevelModuleExtension.getInstance((Module)module).getLanguageLevel();
            if (languageLevel == null) {
                languageLevel = projectLanguageLevel;
            }
            RefManager refManager = globalContext.getRefManager();
            RefModule refModule = refManager.getRefModule(module);
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                Module dependantModule;
                if (!(entry instanceof ModuleOrderEntry) || (dependantModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                LanguageLevel dependantLanguageLevel = LanguageLevelModuleExtension.getInstance((Module)dependantModule).getLanguageLevel();
                if (dependantLanguageLevel == null) {
                    dependantLanguageLevel = projectLanguageLevel;
                }
                if (languageLevel.compareTo((Enum)dependantLanguageLevel) >= 0) continue;
                CommonProblemDescriptor problemDescriptor = manager.createProblemDescriptor("Inconsistent language level settings: module " + module.getName() + " with language level " + languageLevel + " depends on module " + dependantModule.getName() + " with language level " + dependantLanguageLevel, new QuickFix[]{new UnnecessaryModuleDependencyInspection.RemoveModuleDependencyFix(module, dependantModule), QuickFixFactory.getInstance().createShowModulePropertiesFix(module)});
                problemProcessor.addProblemElement((RefEntity)refModule, new CommonProblemDescriptor[]{problemDescriptor});
            }
        }
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.MODULARIZATION_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        if ("Inconsistent language level settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "getDisplayName"));
        }
        return "Inconsistent language level settings";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("InconsistentLanguageLevel" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection", "getShortName"));
        }
        return "InconsistentLanguageLevel";
    }
}

