/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;

class AnnotateTask
implements SequentialTask {
    private final Project myProject;
    private UsageInfo[] myInfos;
    private final SequentialModalProgressTask myTask;
    private int myCount = 0;
    private final int myTotal;
    private final NullableNotNullManager myNotNullManager;

    public AnnotateTask(Project project, SequentialModalProgressTask progressTask, UsageInfo[] infos) {
        this.myProject = project;
        this.myInfos = infos;
        this.myNotNullManager = NullableNotNullManager.getInstance((Project)this.myProject);
        this.myTask = progressTask;
        this.myTotal = infos.length;
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myCount > this.myTotal - 1;
    }

    public boolean iteration() {
        ProgressIndicator indicator = this.myTask.getIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount / (double)this.myTotal);
        }
        NullityInferrer.apply(this.myProject, this.myNotNullManager, this.myInfos[this.myCount++]);
        return this.isDone();
    }

    public void stop() {
    }
}

