/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.EvaluateActionHandler;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.debugger.ui.DebuggerSessionTab;
import com.intellij.debugger.ui.EvaluationDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ex.AbstractDelegatingToRootTraversalPolicy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ExpressionEvaluationDialog
extends EvaluationDialog {
    public ExpressionEvaluationDialog(Project project, TextWithImports defaultExpression) {
        super(project, defaultExpression);
        this.setTitle(DebuggerBundle.message((String)"evaluate.expression.dialog.title", (Object[])new Object[0]));
        KeyStroke expressionStroke = KeyStroke.getKeyStroke(69, 8);
        KeyStroke resultStroke = KeyStroke.getKeyStroke(82, 8);
        final JRootPane rootPane = this.getRootPane();
        final AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ExpressionEvaluationDialog.this.getExpressionCombo().requestFocus();
            }
        };
        anAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(expressionStroke), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                anAction.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        final AnAction anAction2 = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ExpressionEvaluationDialog.this.getEvaluationPanel().getWatchTree().requestFocus();
            }
        };
        anAction2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(resultStroke), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                anAction2.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        this.init();
    }

    @Override
    protected DebuggerExpressionComboBox createEditor(CodeFragmentFactory factory) {
        return new DebuggerExpressionComboBox(this.getProject(), PositionUtil.getContextElement((StackFrameContext)this.getDebuggerContext()), "evaluation", factory);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        final JPanel exprPanel = new JPanel(new BorderLayout(10, 0));
        exprPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.evaluate.dialog.expression", (Object[])new Object[0])), "West");
        exprPanel.add((Component)this.getExpressionCombo(), "Center");
        JBLabel help = new JBLabel("Press Enter to Evaluate or Control+Enter to evaluate and add to the Watches", 4);
        help.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)6, (int)0));
        help.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        help.setFontColor(UIUtil.FontColor.BRIGHTER);
        exprPanel.add((Component)help, "South");
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.add((Component)this.getEvaluationPanel(), "Center");
        panel.add((Component)exprPanel, "North");
        panel.add((Component)resultPanel, "Center");
        panel.setFocusTraversalPolicyProvider(true);
        panel.setFocusTraversalPolicy(new AbstractDelegatingToRootTraversalPolicy(){

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                boolean focusExpressionCombo = this.isParent(aComponent, ExpressionEvaluationDialog.this.getEvaluationPanel());
                return focusExpressionCombo ? ExpressionEvaluationDialog.this.getExpressionCombo().getEditorComponent() : super.getComponentBefore(aContainer, aComponent);
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                boolean focusEvaluationPanel = this.isParent(aComponent, exprPanel);
                return focusEvaluationPanel ? ExpressionEvaluationDialog.this.getEvaluationPanel().getTree() : super.getComponentAfter(aContainer, aComponent);
            }

            private boolean isParent(@NotNull Component component, @NotNull Container parent) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/ui/ExpressionEvaluationDialog$5", "isParent"));
                }
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/debugger/ui/ExpressionEvaluationDialog$5", "isParent"));
                }
                for (Component c = component; c != null; c = c.getParent()) {
                    if (c != parent) continue;
                    return true;
                }
                return false;
            }
        });
        return panel;
    }

    @Override
    protected void initDialogData(TextWithImports text) {
        super.initDialogData(text);
        this.getExpressionCombo().selectAll();
    }

    private DebuggerExpressionComboBox getExpressionCombo() {
        return (DebuggerExpressionComboBox)this.getEditor();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new SwitchAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/ExpressionEvaluationDialog", "createActions"));
        }
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DialogWrapper.OkAction(){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                if ((e.getModifiers() & 2) != 0) {
                    ExpressionEvaluationDialog.this.addCurrentExpressionToWatches();
                }
            }
        };
    }

    private void addCurrentExpressionToWatches() {
        TextWithImports evaluate;
        DebuggerSessionTab tab = DebuggerPanelsManager.getInstance(this.getProject()).getSessionTab();
        if (tab != null && (evaluate = this.getCodeToEvaluate()) != null) {
            tab.getWatchPanel().getWatchTree().addWatch(evaluate, null);
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("debugging.debugMenu.evaluate");
    }

    private class SwitchAction
    extends AbstractAction {
        public SwitchAction() {
            this.putValue("Name", DebuggerBundle.message((String)"action.evaluate.expression.dialog.switch.mode.description", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final TextWithImports text = ExpressionEvaluationDialog.this.getEditor().getText();
            ExpressionEvaluationDialog.this.doCancelAction();
            DebuggerInvocationUtil.invokeLater(ExpressionEvaluationDialog.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    EvaluateActionHandler.showEvaluationDialog(ExpressionEvaluationDialog.this.getProject(), text, "EvaluateFragment");
                }
            });
        }
    }
}

