/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddWildcardBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaWildcardMethodBreakpointType
extends JavaBreakpointTypeBase<JavaMethodBreakpointProperties>
implements JavaBreakpointType {
    public JavaWildcardMethodBreakpointType() {
        super("java-wildcard-method", DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaWildcardMethodBreakpointType", "getEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaWildcardMethodBreakpointType", "getDisabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaWildcardMethodBreakpointType", "getMutedEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaWildcardMethodBreakpointType", "getMutedDisabledIcon"));
        }
        return icon;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getDisplayText(XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaMethodBreakpointType.getText(breakpoint);
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<JavaMethodBreakpointProperties>> createCustomPropertiesPanel() {
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public XBreakpoint<JavaMethodBreakpointProperties> addBreakpoint(final Project project, JComponent parentComponent) {
        final AddWildcardBreakpointDialog dialog = new AddWildcardBreakpointDialog(project);
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        return (XBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XBreakpoint<JavaMethodBreakpointProperties>>(){

            public XBreakpoint<JavaMethodBreakpointProperties> compute() {
                return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)JavaWildcardMethodBreakpointType.this, (XBreakpointProperties)new JavaMethodBreakpointProperties(dialog.getClassPattern(), dialog.getMethodName()));
            }
        });
    }

    @NotNull
    public Breakpoint createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        WildcardMethodBreakpoint wildcardMethodBreakpoint = new WildcardMethodBreakpoint(project, breakpoint);
        if (wildcardMethodBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaWildcardMethodBreakpointType", "createJavaBreakpoint"));
        }
        return wildcardMethodBreakpoint;
    }
}

