/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDescriptorImpl
extends ValueDescriptorImpl
implements LocalVariableDescriptor {
    private final StackFrameProxyImpl myFrameProxy;
    private final LocalVariableProxyImpl myLocalVariable;
    private String myTypeName;
    private boolean myIsPrimitive;
    private boolean myIsNewLocal;

    public LocalVariableDescriptorImpl(Project project, @NotNull LocalVariableProxyImpl local) {
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl", "<init>"));
        }
        super(project);
        this.myTypeName = DebuggerBundle.message((String)"label.unknown.value", (Object[])new Object[0]);
        this.myIsNewLocal = true;
        this.setLvalue(true);
        this.myFrameProxy = local.getFrame();
        this.myLocalVariable = local;
    }

    @Override
    public LocalVariableProxyImpl getLocalVariable() {
        return this.myLocalVariable;
    }

    @Nullable
    public SourcePosition getSourcePosition(Project project, DebuggerContextImpl context) {
        return this.getSourcePosition(project, context, false);
    }

    @Nullable
    public SourcePosition getSourcePosition(Project project, DebuggerContextImpl context, boolean nearest) {
        StackFrameProxyImpl frame = context.getFrameProxy();
        if (frame == null) {
            return null;
        }
        PsiElement place = PositionUtil.getContextElement((StackFrameContext)context);
        if (place == null) {
            return null;
        }
        PsiVariable psiVariable = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(this.getName(), place);
        if (psiVariable == null) {
            return null;
        }
        PsiFile containingFile = psiVariable.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (nearest) {
            return DebuggerContextUtil.findNearest(context, (PsiElement)psiVariable, containingFile);
        }
        return SourcePosition.createFromOffset((PsiFile)containingFile, (int)psiVariable.getTextOffset());
    }

    public boolean isNewLocal() {
        return this.myIsNewLocal;
    }

    @Override
    public boolean isPrimitive() {
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        boolean isVisible = this.myFrameProxy.isLocalVariableVisible(this.getLocalVariable());
        if (isVisible) {
            String typeName;
            this.myTypeName = typeName = this.getLocalVariable().typeName();
            this.myIsPrimitive = DebuggerUtils.isPrimitiveType((String)typeName);
            return this.myFrameProxy.getValue(this.getLocalVariable());
        }
        return null;
    }

    public void setNewLocal(boolean aNew) {
        this.myIsNewLocal = aNew;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        super.displayAs(descriptor);
        if (descriptor instanceof LocalVariableDescriptorImpl) {
            this.myIsNewLocal = ((LocalVariableDescriptorImpl)descriptor).myIsNewLocal;
        }
    }

    @Override
    public String getName() {
        return this.myLocalVariable.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String calcValueName() {
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(this.getName());
            if (classRenderer.SHOW_DECLARED_TYPE) {
                buf.append(": ");
                buf.append(classRenderer.renderTypeName(this.myTypeName));
            }
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

