/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import javax.swing.Icon;

public class InvalidateCachesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText(ApplicationManager.getApplication().isRestartCapable() ? "Invalidate Caches / Restart..." : "Invalidate Caches...");
    }

    public void actionPerformed(AnActionEvent e) {
        int result;
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        boolean mac = Messages.canShowMacSheetPanel();
        boolean canRestart = app.isRestartCapable();
        String[] options = new String[canRestart ? 4 : 3];
        options[0] = canRestart ? "Invalidate and Restart" : "Invalidate and Exit";
        options[1] = mac ? "Cancel" : "Invalidate";
        String string = options[2] = mac ? "Invalidate" : "Cancel";
        if (canRestart) {
            options[3] = "Just Restart";
        }
        if ((result = Messages.showDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)"The caches will be invalidated and rebuilt on the next startup.\nWARNING: Local History will be also cleared.\n\nWould you like to continue?\n\n", (String)"Invalidate Caches", (String[])options, (int)0, (Icon)Messages.getWarningIcon())) == -1 || result == (mac ? 1 : 2)) {
            return;
        }
        if (result == 3) {
            app.restart(true);
            return;
        }
        UsageTrigger.trigger(ApplicationManagerEx.getApplicationEx().getName() + ".caches.invalidated");
        FSRecords.invalidateCaches();
        if (result == 0) {
            app.restart(true);
        }
    }
}

