/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Font;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.Nullable;

public class TogglePresentationModeAction
extends AnAction
implements DumbAware {
    private static final Map<Object, Object> ourSavedValues = ContainerUtil.newLinkedHashMap();
    private static int ourSavedConsoleFontSize;

    public void update(AnActionEvent e) {
        boolean selected = UISettings.getInstance().PRESENTATION_MODE;
        e.getPresentation().setText(selected ? "Exit Presentation Mode" : "Enter Presentation Mode");
    }

    public void actionPerformed(AnActionEvent e) {
        UISettings settings = UISettings.getInstance();
        Project project = e.getProject();
        TogglePresentationModeAction.setPresentationMode(project, !settings.PRESENTATION_MODE);
    }

    public static void setPresentationMode(final Project project, final boolean inPresentation) {
        final UISettings settings = UISettings.getInstance();
        settings.PRESENTATION_MODE = inPresentation;
        final boolean layoutStored = TogglePresentationModeAction.storeToolWindows(project);
        TogglePresentationModeAction.tweakUIDefaults(settings, inPresentation);
        ActionCallback callback = project == null ? ActionCallback.DONE : TogglePresentationModeAction.tweakFrameFullScreen(project, inPresentation);
        callback.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                TogglePresentationModeAction.tweakEditorAndFireUpdateUI(settings, inPresentation);
                TogglePresentationModeAction.restoreToolWindows(project, layoutStored, inPresentation);
            }
        });
    }

    private static ActionCallback tweakFrameFullScreen(Project project, boolean inPresentation) {
        Window window = IdeFrameImpl.getActiveFrame();
        if (window instanceof IdeFrameImpl) {
            IdeFrameImpl frame = (IdeFrameImpl)window;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            if (inPresentation) {
                propertiesComponent.setValue("full.screen.before.presentation.mode", String.valueOf(frame.isInFullScreen()));
                return frame.toggleFullScreen(true);
            }
            if (frame.isInFullScreen()) {
                String value = propertiesComponent.getValue("full.screen.before.presentation.mode");
                return frame.toggleFullScreen("true".equalsIgnoreCase(value));
            }
        }
        return ActionCallback.DONE;
    }

    private static void tweakEditorAndFireUpdateUI(UISettings settings, boolean inPresentation) {
        int fontSize;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        int n = fontSize = inPresentation ? settings.PRESENTATION_MODE_FONT_SIZE : globalScheme.getEditorFontSize();
        if (inPresentation) {
            ourSavedConsoleFontSize = globalScheme.getConsoleFontSize();
            globalScheme.setConsoleFontSize(fontSize);
        } else {
            globalScheme.setConsoleFontSize(ourSavedConsoleFontSize);
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (!(editor instanceof EditorEx)) continue;
            ((EditorEx)editor).setFontSize(fontSize);
        }
        UISettings.getInstance().fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
    }

    private static void tweakUIDefaults(UISettings settings, boolean inPresentation) {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        if (inPresentation) {
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(key instanceof String)) continue;
                String name = (String)key;
                if (name.endsWith(".font")) {
                    Font font = defaults.getFont(key);
                    ourSavedValues.put(key, font);
                    continue;
                }
                if (!name.endsWith(".rowHeight")) continue;
                ourSavedValues.put(key, defaults.getInt(key));
            }
            for (Object key : ourSavedValues.keySet()) {
                Object v = ourSavedValues.get(key);
                if (v instanceof Font) {
                    Font font = (Font)v;
                    defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), Math.min(20, settings.PRESENTATION_MODE_FONT_SIZE)));
                    continue;
                }
                if (!(v instanceof Integer)) continue;
                defaults.put(key, (Object)((Integer)v * 3 / 2));
            }
        } else {
            for (Object key : ourSavedValues.keySet()) {
                defaults.put(key, ourSavedValues.get(key));
            }
            ourSavedValues.clear();
        }
    }

    private static boolean hideAllToolWindows(ToolWindowManagerEx manager) {
        manager.clearSideStack();
        String[] ids = manager.getToolWindowIds();
        boolean hasVisible = false;
        for (String id : ids) {
            ToolWindow toolWindow = manager.getToolWindow(id);
            if (!toolWindow.isVisible()) continue;
            toolWindow.hide(null);
            hasVisible = true;
        }
        return hasVisible;
    }

    private static boolean storeToolWindows(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout layout = new DesktopLayout();
        layout.copyFrom(manager.getLayout());
        boolean hasVisible = TogglePresentationModeAction.hideAllToolWindows(manager);
        if (hasVisible) {
            manager.setLayoutToRestoreLater(layout);
            manager.activateEditorComponent();
        }
        return hasVisible;
    }

    private static void restoreToolWindows(Project project, boolean needsRestore, boolean inPresentation) {
        if (project == null || !needsRestore) {
            return;
        }
        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout restoreLayout = manager.getLayoutToRestoreLater();
        if (!inPresentation && restoreLayout != null) {
            manager.setLayout(restoreLayout);
        }
    }
}

