/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.CommonBundle;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jetbrains.annotations.Nullable;

public class CustomizeUIThemeStepPanel
extends AbstractCustomizeWizardStep {
    protected static final String DEFAULT = "Default";
    protected static final String DARCULA = "Darcula";
    protected static final String INTELLIJ = "IntelliJ";
    protected static final String ALLOY = "Alloy. IDEA Theme";
    protected static final String GTK = "GTK+";
    private boolean myInitial = true;
    private boolean myColumnMode;
    private JLabel myPreviewLabel;
    private Map<String, Icon> myLafNames = new LinkedHashMap<String, Icon>();

    public CustomizeUIThemeStepPanel() {
        this.setLayout(CustomizeUIThemeStepPanel.createSmallBorderLayout());
        IconLoader.activate();
        this.initLafs();
        this.myColumnMode = this.myLafNames.size() > 2;
        JPanel buttonsPanel = new JPanel(new GridLayout(this.myColumnMode ? this.myLafNames.size() : 1, this.myColumnMode ? 1 : this.myLafNames.size(), 5, 5));
        ButtonGroup group = new ButtonGroup();
        String myDefaultLafName = null;
        for (Map.Entry<String, Icon> entry : this.myLafNames.entrySet()) {
            final String lafName = entry.getKey();
            Icon icon = entry.getValue();
            JRadioButton radioButton = new JRadioButton(lafName, myDefaultLafName == null);
            radioButton.setOpaque(false);
            if (myDefaultLafName == null) {
                radioButton.setSelected(true);
                myDefaultLafName = lafName;
            }
            JPanel panel = CustomizeUIThemeStepPanel.createBigButtonPanel(CustomizeUIThemeStepPanel.createSmallBorderLayout(), radioButton, new Runnable(){

                @Override
                public void run() {
                    CustomizeUIThemeStepPanel.this.applyLaf(lafName, CustomizeUIThemeStepPanel.this);
                }
            });
            panel.setBorder(CustomizeUIThemeStepPanel.createSmallEmptyBorder());
            panel.add((Component)radioButton, this.myColumnMode ? "West" : "North");
            JLabel label = new JLabel(this.myColumnMode ? IconUtil.scale((Icon)IconUtil.cropIcon((Icon)icon, (int)(icon.getIconWidth() * 2 / 3), (int)(icon.getIconHeight() * 2 / 3)), (double)0.5) : icon);
            label.setVerticalAlignment(1);
            label.setHorizontalAlignment(4);
            panel.add((Component)label, "Center");
            group.add(radioButton);
            buttonsPanel.add(panel);
        }
        this.add((Component)buttonsPanel, "Center");
        this.myPreviewLabel = new JLabel();
        this.myPreviewLabel.setHorizontalAlignment(this.myColumnMode ? 2 : 0);
        this.myPreviewLabel.setVerticalAlignment(0);
        if (this.myColumnMode) {
            this.add((Component)buttonsPanel, "West");
            JPanel wrapperPanel = new JPanel(new FlowLayout(0, 0, 0));
            wrapperPanel.add(this.myPreviewLabel);
            this.add((Component)wrapperPanel, "Center");
        }
        this.applyLaf(myDefaultLafName, this);
        this.myInitial = false;
    }

    protected void initLafs() {
        if (SystemInfo.isMac) {
            this.addLaf(DEFAULT, "/lafs/OSXAqua.png");
            this.addLaf(DARCULA, "/lafs/OSXDarcula.png");
        } else if (SystemInfo.isWindows) {
            this.addLaf(INTELLIJ, "/lafs/WindowsIntelliJ.png");
            this.addLaf(DARCULA, "/lafs/WindowsDarcula.png");
        } else {
            this.addLaf(INTELLIJ, "/lafs/LinuxIntelliJ.png");
            this.addLaf(DARCULA, "/lafs/LinuxDarcula.png");
            this.addLaf(GTK, "/lafs/LinuxGTK.png");
        }
    }

    protected final void addLaf(String name, String icon) {
        this.myLafNames.put(name, IconLoader.getIcon((String)icon));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 30;
        return size;
    }

    @Override
    public String getTitle() {
        return "UI Themes";
    }

    @Override
    public String getHTMLHeader() {
        return "<html><body><h2>Set UI theme</h2>&nbsp;</body></html>";
    }

    @Override
    public String getHTMLFooter() {
        return "UI theme can be changed later in " + CommonBundle.settingsTitle() + " | " + OptionsBundle.message((String)"configurable.group.appearance.settings.display.name", (Object[])new Object[0]) + " | " + "Appearance";
    }

    private void applyLaf(String lafName, Component component) {
        UIManager.LookAndFeelInfo info = CustomizeUIThemeStepPanel.getLookAndFeelInfo(lafName);
        if (info == null) {
            return;
        }
        try {
            Window window;
            UIManager.setLookAndFeel(info.getClassName());
            String className = info.getClassName();
            if (lafName == DARCULA) {
                className = DarculaLookAndFeelInfo.CLASS_NAME;
            }
            if (!this.myInitial) {
                StartupUtil.setWizardLAF(className);
            }
            if ((window = SwingUtilities.getWindowAncestor(component)) != null) {
                if (SystemInfo.isMac) {
                    window.setBackground(new Color(UIUtil.getPanelBackground().getRGB()));
                }
                SwingUtilities.updateComponentTreeUI(window);
            }
            if (ApplicationManager.getApplication() != null) {
                LafManager.getInstance().setCurrentLookAndFeel(info);
            }
            if (this.myColumnMode) {
                this.myPreviewLabel.setIcon(this.myLafNames.get(lafName));
                this.myPreviewLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.disabledForeground")));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    private static UIManager.LookAndFeelInfo getLookAndFeelInfo(String name) {
        if (DEFAULT.equals(name)) {
            return new UIManager.LookAndFeelInfo(DEFAULT, "com.apple.laf.AquaLookAndFeel");
        }
        if (DARCULA.equals(name)) {
            return new UIManager.LookAndFeelInfo(DARCULA, DarculaLaf.class.getName());
        }
        if (INTELLIJ.equals(name)) {
            return new UIManager.LookAndFeelInfo(INTELLIJ, IntelliJLaf.class.getName());
        }
        if (ALLOY.equals(name)) {
            return new UIManager.LookAndFeelInfo(ALLOY, "com.incors.plaf.alloy.AlloyIdea");
        }
        if (GTK.equals(name)) {
            return new UIManager.LookAndFeelInfo(GTK, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        }
        return null;
    }
}

