/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.StringTokenizer;

public class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static PsiDirectory mkdirs(PsiManager manager, String path) throws IncorrectOperationException {
        if (File.separatorChar != '/' && path.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("separators must be '/'; path is " + path);
        }
        String existingPath = path;
        PsiDirectory directory = null;
        while (existingPath.length() > 0) {
            int index;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(existingPath);
            if (file != null) {
                directory = manager.findDirectory(file);
                if (directory != null) break;
                return null;
            }
            if (StringUtil.endsWithChar((CharSequence)existingPath, (char)'/')) {
                existingPath = existingPath.substring(0, existingPath.length() - 1);
                if (SystemInfo.isWindows && existingPath.length() == 2 && existingPath.charAt(1) == ':') {
                    return null;
                }
            }
            if ((index = existingPath.lastIndexOf(47)) == -1) {
                return null;
            }
            existingPath = existingPath.substring(0, index);
        }
        if (directory == null) {
            return null;
        }
        if (existingPath.equals(path)) {
            return directory;
        }
        String postfix = path.substring(existingPath.length() + 1, path.length());
        StringTokenizer tokenizer = new StringTokenizer(postfix, "/");
        while (tokenizer.hasMoreTokens()) {
            directory = directory.createSubdirectory(tokenizer.nextToken());
        }
        return directory;
    }

    public static PsiDirectory createSubdirectories(String subDirName, PsiDirectory baseDirectory, String delim) throws IncorrectOperationException {
        StringTokenizer tokenizer = new StringTokenizer(subDirName, delim);
        PsiDirectory dir = baseDirectory;
        while (tokenizer.hasMoreTokens()) {
            PsiDirectory existingDir;
            String packName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens() && (existingDir = dir.findSubdirectory(packName)) != null) {
                dir = existingDir;
                continue;
            }
            dir = dir.createSubdirectory(packName);
        }
        return dir;
    }
}

