/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class JSStringLiteralEscaper<T extends PsiLanguageInjectionHost>
extends LiteralTextEscaper<T> {
    private int[] outSourceOffsets;

    public JSStringLiteralEscaper(T host) {
        super(host);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/json/psi/impl/JSStringLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/json/psi/impl/JSStringLiteralEscaper", "decode"));
        }
        ProperTextRange.assertProperRange((Segment)rangeInsideHost);
        String subText = rangeInsideHost.substring(this.myHost.getText());
        Ref sourceOffsetsRef = new Ref();
        boolean result = JSStringLiteralEscaper.parseStringCharacters(subText, outChars, (Ref<int[]>)sourceOffsetsRef, this.isRegExpLiteral());
        this.outSourceOffsets = (int[])sourceOffsetsRef.get();
        return result;
    }

    protected abstract boolean isRegExpLiteral();

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/json/psi/impl/JSStringLiteralEscaper", "getOffsetInHost"));
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return (result <= rangeInsideHost.getLength() ? result : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    public static boolean parseStringCharacters(String chars, StringBuilder outChars, Ref<int[]> sourceOffsetsRef, boolean regExp) {
        int[] sourceOffsets = new int[chars.length() + 1];
        sourceOffsetsRef.set((Object)sourceOffsets);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            for (int i = 0; i < sourceOffsets.length; ++i) {
                sourceOffsets[i] = i;
            }
            return true;
        }
        int index = 0;
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            sourceOffsets[outChars.length()] = index - 1;
            sourceOffsets[outChars.length() + 1] = index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                outChars.append(c);
            } else {
                switch (c) {
                    case 'b': {
                        outChars.append('\b');
                        break;
                    }
                    case 't': {
                        outChars.append('\t');
                        break;
                    }
                    case 'n': {
                        outChars.append('\n');
                        break;
                    }
                    case 'f': {
                        outChars.append('\f');
                        break;
                    }
                    case 'r': {
                        outChars.append('\r');
                        break;
                    }
                    case '\"': {
                        outChars.append('\"');
                        break;
                    }
                    case '/': {
                        outChars.append('/');
                        break;
                    }
                    case '\n': {
                        outChars.append('\n');
                        break;
                    }
                    case '\'': {
                        outChars.append('\'');
                        break;
                    }
                    case '\\': {
                        outChars.append('\\');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char startC = c;
                        int v = c - 48;
                        if (index < chars.length()) {
                            if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                v <<= 3;
                                v += c - 48;
                                if (startC <= '3' && index < chars.length()) {
                                    if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                        v <<= 3;
                                        v += c - 48;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        outChars.append((char)v);
                        break;
                    }
                    case 'x': {
                        int v;
                        if (index + 2 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index, index + 2), 16);
                                outChars.append((char)v);
                                index += 2;
                                break;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    case 'u': {
                        int v;
                        if (index + 4 <= chars.length()) {
                            try {
                                v = Integer.parseInt(chars.substring(index, index + 4), 16);
                                if (v == 10 || v == 13) {
                                    return false;
                                }
                                c = chars.charAt(index);
                                if (c == '+' || c == '-') {
                                    return false;
                                }
                                outChars.append((char)v);
                                index += 4;
                                break;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            sourceOffsets[outChars.length()] = --index;
        }
        return true;
    }
}

