/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.Producer;
import com.intellij.util.net.IOExceptionDialog;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubDownloadUtil {
    private GithubDownloadUtil() {
    }

    @NotNull
    private static String formatGithubRepositoryName(@NotNull String userName, @NotNull String repositoryName) {
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "formatGithubRepositoryName"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "formatGithubRepositoryName"));
        }
        String string = "github-" + userName + "-" + repositoryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "formatGithubRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static File getCacheDir(@NotNull String userName, @NotNull String repositoryName) {
        File file;
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "getCacheDir"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "getCacheDir"));
        }
        File generatorsDir = new File(PathManager.getSystemPath(), "projectGenerators");
        String dirName = GithubDownloadUtil.formatGithubRepositoryName(userName, repositoryName);
        File dir = new File(generatorsDir, dirName);
        try {
            file = dir.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = dir;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "getCacheDir"));
            }
            return file2;
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "getCacheDir"));
        }
        return file;
    }

    public static File findCacheFile(@NotNull String userName, @NotNull String repositoryName, @NotNull String cacheFileName) {
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "findCacheFile"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "findCacheFile"));
        }
        if (cacheFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheFileName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "findCacheFile"));
        }
        File dir = GithubDownloadUtil.getCacheDir(userName, repositoryName);
        return new File(dir, cacheFileName);
    }

    public static void downloadContentToFileWithProgressSynchronously(@Nullable Project project, final @NotNull String url, @NotNull String progressTitle, final @NotNull File outputFile, final @NotNull String userName, final @NotNull String repositoryName, final boolean retryOnError) throws GeneratorException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadContentToFileWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadContentToFileWithProgressSynchronously"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadContentToFileWithProgressSynchronously"));
        }
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadContentToFileWithProgressSynchronously"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadContentToFileWithProgressSynchronously"));
        }
        Outcome<File> outcome = DownloadUtil.provideDataWithProgressSynchronously(project, progressTitle, "Downloading zip archive${content-length} ...", new Callable<File>(){

            @Override
            public File call() throws Exception {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                GithubDownloadUtil.downloadAtomically(progress, url, outputFile, userName, repositoryName);
                return outputFile;
            }
        }, new Producer<Boolean>(){

            public Boolean produce() {
                if (!retryOnError) {
                    return false;
                }
                return IOExceptionDialog.showErrorDialog((String)"Download Error", (String)("Can not download '" + url + "'"));
            }
        });
        File out = outcome.get();
        if (out != null) {
            return;
        }
        Exception e = outcome.getException();
        if (e != null) {
            throw new GeneratorException("Can not fetch content from " + url);
        }
        throw new GeneratorException("Download was cancelled");
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull String userName, @NotNull String repositoryName) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadAtomically"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadAtomically"));
        }
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadAtomically"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil", "downloadAtomically"));
        }
        String tempFileName = String.format("github-%s-%s-%s", userName, repositoryName, outputFile.getName());
        File tempFile = FileUtil.createTempFile((String)(tempFileName + "-"), (String)".tmp");
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile);
    }
}

