/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffSideView;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.util.Disposer;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffPanelOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.ex.DiffPanelOptions");
    private final DiffPanelImpl myDiffPanel;
    private boolean myRequestFocusOnNewContent = true;
    private ShowSourcePolicy myShowSourcePolicy = ShowSourcePolicy.DEFAULT;

    public DiffPanelOptions(DiffPanelImpl diffPanel) {
        this.myDiffPanel = diffPanel;
    }

    public void onNewContent(DiffSideView currentSide) {
        if (this.myRequestFocusOnNewContent) {
            currentSide.getFocusableComponent().requestFocus();
        }
    }

    public void setRequestFocusOnNewContent(boolean requestFocusOnNewContent) {
        this.myRequestFocusOnNewContent = requestFocusOnNewContent;
    }

    public void setShowSourcePolicy(ShowSourcePolicy showSourcePolicy) {
        if (showSourcePolicy == null) {
            LOG.error("");
            return;
        }
        this.myShowSourcePolicy = showSourcePolicy;
    }

    public void showSource(@Nullable OpenFileDescriptor descriptor) {
        if (descriptor == null || this.myDiffPanel.getProject() == null) {
            return;
        }
        this.myShowSourcePolicy.showSource(descriptor, this.myDiffPanel);
    }

    public static interface ShowSourcePolicy {
        public static final ShowSourcePolicy DONT_SHOW = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$1", "showSource"));
                }
                if (diffPanel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$1", "showSource"));
                }
            }
        };
        public static final ShowSourcePolicy OPEN_EDITOR = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$2", "showSource"));
                }
                if (diffPanel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$2", "showSource"));
                }
                FileEditorManager.getInstance((Project)diffPanel.getProject()).openTextEditor(descriptor, true);
            }
        };
        public static final ShowSourcePolicy OPEN_EDITOR_AND_CLOSE_DIFF = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$3", "showSource"));
                }
                if (diffPanel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$3", "showSource"));
                }
                OPEN_EDITOR.showSource(descriptor, diffPanel);
                if (diffPanel.getOwnerWindow() == null) {
                    return;
                }
                Disposer.dispose((Disposable)diffPanel);
                if (!this.dialogWrapperClose(diffPanel.getOwnerWindow())) {
                    diffPanel.getOwnerWindow().setVisible(false);
                    diffPanel.getOwnerWindow().dispose();
                }
            }

            private boolean dialogWrapperClose(Container window) {
                if (!(window instanceof DialogWrapperDialog)) {
                    return false;
                }
                while (window instanceof DialogWrapperDialog) {
                    DialogWrapperDialog dlg = (DialogWrapperDialog)window;
                    window = window.getParent();
                    dlg.getDialogWrapper().doCancelAction();
                }
                return true;
            }
        };
        public static final ShowSourcePolicy DEFAULT = new ShowSourcePolicy(){

            @Override
            public void showSource(@NotNull OpenFileDescriptor descriptor, @NotNull DiffPanelImpl diffPanel) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$4", "showSource"));
                }
                if (diffPanel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/ex/DiffPanelOptions$ShowSourcePolicy$4", "showSource"));
                }
                Window window = diffPanel.getOwnerWindow();
                if (window == null) {
                    return;
                }
                if (window instanceof Frame) {
                    OPEN_EDITOR.showSource(descriptor, diffPanel);
                } else {
                    OPEN_EDITOR_AND_CLOSE_DIFF.showSource(descriptor, diffPanel);
                }
            }
        };

        public void showSource(@NotNull OpenFileDescriptor var1, @NotNull DiffPanelImpl var2);
    }
}

