/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class DiffStatusBar
extends JPanel {
    private final Collection<JComponent> myLabels = new ArrayList<JComponent>();
    private final JLabel myTextLabel = new JLabel("");
    private static final int COMP_HEIGHT = 30;
    private EditorColorsScheme myColorScheme = null;

    public <T extends LegendTypeDescriptor> DiffStatusBar(List<T> types) {
        for (LegendTypeDescriptor differenceType : types) {
            this.addDiffType(differenceType);
        }
        this.initGui();
    }

    private void addDiffType(LegendTypeDescriptor diffType) {
        this.addComponent(diffType);
    }

    private void addComponent(LegendTypeDescriptor diffType) {
        SingleDiffLegendComponent component = new SingleDiffLegendComponent(diffType);
        this.myLabels.add(component);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = super.getPreferredSize();
        Dimension m = super.getMinimumSize();
        return new Dimension(m.width, p.height);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension p = super.getPreferredSize();
        Dimension m = super.getMaximumSize();
        return new Dimension(m.width, p.height);
    }

    public void setText(String text) {
        this.myTextLabel.setText(text);
    }

    private void initGui() {
        JComponent filler = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                return DiffStatusBar.this.myTextLabel.getPreferredSize();
            }
        };
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 20, 3, 20));
        this.add((Component)this.myTextLabel, "West");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel(new GridLayout(1, this.myLabels.size(), 0, 0));
        for (JComponent myLabel : this.myLabels) {
            panel.add(myLabel);
        }
        panel.setMaximumSize(panel.getPreferredSize());
        box.add(panel);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, "Center");
        this.add((Component)filler, "East");
    }

    public void setColorScheme(EditorColorsScheme colorScheme) {
        EditorColorsScheme oldScheme = this.myColorScheme;
        this.myColorScheme = colorScheme;
        if (oldScheme != colorScheme) {
            this.repaint();
        }
    }

    private class SingleDiffLegendComponent
    extends JPanel {
        private static final int HORIZONTAL_PADDING = 70;
        private final LegendTypeDescriptor myDiffType;

        public SingleDiffLegendComponent(LegendTypeDescriptor diffType) {
            this.myDiffType = diffType;
        }

        @Override
        public void paint(Graphics g) {
            this.setBackground(UIUtil.getPanelBackground());
            super.paint(g);
            GraphicsUtil.setupAntialiasing((Graphics)g);
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            EditorColorsScheme colorScheme = DiffStatusBar.this.myColorScheme != null ? DiffStatusBar.this.myColorScheme : EditorColorsManager.getInstance().getGlobalScheme();
            g.setColor(this.myDiffType.getLegendColor(colorScheme));
            int RECT_WIDTH = 35;
            g.fill3DRect(0, (this.getHeight() - 10) / 2, 35, 10, true);
            Font font = g.getFont();
            if (font.getStyle() != 0) {
                font = font.deriveFont(0);
            }
            g.setFont(font);
            g.setColor(UIUtil.getLabelForeground());
            int textBaseline = (this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
            g.drawString(this.myDiffType.getDisplayName(), 45, textBaseline);
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int stringWidth = (int)metrics.getStringBounds(this.myDiffType.getDisplayName(), this.getGraphics()).getWidth();
            return new Dimension(70 + stringWidth, 30);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static interface LegendTypeDescriptor {
        public String getDisplayName();

        @Nullable
        public Color getLegendColor(EditorColorsScheme var1);
    }
}

