/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.actions.MergeActionGroup;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.DiffLineMarkerRenderer;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.InlineFragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentBoundRenderer;
import com.intellij.openapi.diff.impl.util.GutterActionRenderer;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffMarkup
implements EditorSource,
Disposable {
    private static final Logger LOG = Logger.getInstance(DiffMarkup.class);
    private static final int LAYER = 5999;
    private final ArrayList<RangeHighlighter> myExtraHighLighters;
    private final ArrayList<RangeHighlighter> myHighLighters;
    private final HashSet<RangeHighlighter> myActionHighlighters;
    @Nullable
    private final Project myProject;
    private final List<Disposable> myDisposables;
    private boolean myDisposed;

    protected DiffMarkup(@Nullable Project project, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "<init>"));
        }
        this.myExtraHighLighters = new ArrayList();
        this.myHighLighters = new ArrayList();
        this.myActionHighlighters = new HashSet();
        this.myDisposables = new ArrayList<Disposable>();
        this.myDisposed = false;
        this.myProject = project;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Nullable
    private MarkupModel getMarkupModel() {
        EditorEx editor = this.getEditor();
        return editor == null ? null : editor.getMarkupModel();
    }

    public void highlightText(@NotNull Fragment fragment, @Nullable GutterIconRenderer gutterIconRenderer) {
        RangeHighlighter rangeMarker;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "highlightText"));
        }
        MarkupModel markupModel = this.getMarkupModel();
        EditorEx editor = this.getEditor();
        TextDiffTypeEnum diffTypeEnum = fragment.getType();
        if (diffTypeEnum == null || markupModel == null || editor == null) {
            return;
        }
        TextDiffType type = fragment instanceof LineFragment ? DiffUtil.makeTextDiffType((LineFragment)fragment) : TextDiffType.create(diffTypeEnum);
        TextRange range = fragment.getRange(this.getSide());
        final TextAttributes attributes = type.getTextAttributes(editor);
        if (attributes == null) {
            return;
        }
        if (range.getLength() == 0) {
            int offset = range.getStartOffset();
            rangeMarker = markupModel.addRangeHighlighter(offset, offset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
            rangeMarker.setCustomRenderer(new CustomHighlighterRenderer(){

                public void paint(@NotNull Editor ed, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
                    if (ed == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ed", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup$1", "paint"));
                    }
                    if (highlighter == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup$1", "paint"));
                    }
                    if (g == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup$1", "paint"));
                    }
                    g.setColor(attributes.getBackgroundColor());
                    Point point = ed.logicalPositionToXY(ed.offsetToLogicalPosition(highlighter.getStartOffset()));
                    int endy = point.y + ed.getLineHeight() - 1;
                    g.drawLine(point.x, point.y, point.x, endy);
                    g.drawLine(point.x - 1, point.y, point.x - 1, endy);
                }
            });
        } else {
            rangeMarker = markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
        if (gutterIconRenderer != null) {
            rangeMarker.setGutterIconRenderer(gutterIconRenderer);
        }
        DiffMarkup.setLineMarkerRenderer(rangeMarker, fragment, type);
        DiffMarkup.setErrorStripes(rangeMarker, fragment, attributes.getErrorStripeColor());
        this.saveHighlighter(rangeMarker);
    }

    private static void setErrorStripes(@NotNull RangeHighlighter rangeMarker, @NotNull Fragment fragment, @Nullable Color stripeBarColor) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "setErrorStripes"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "setErrorStripes"));
        }
        if (DiffUtil.isInlineWrapper(fragment)) {
            rangeMarker.setErrorStripeMarkColor(null);
        } else if (stripeBarColor != null) {
            rangeMarker.setErrorStripeMarkColor(stripeBarColor);
            rangeMarker.setThinErrorStripeMark(true);
        }
    }

    private static void setLineMarkerRenderer(RangeHighlighter rangeMarker, Fragment fragment, TextDiffType type) {
        if (!(fragment instanceof InlineFragment)) {
            rangeMarker.setLineMarkerRenderer((LineMarkerRenderer)DiffLineMarkerRenderer.createInstance(type));
        }
    }

    public void addLineMarker(int line, @Nullable TextDiffType type, SeparatorPlacement separatorPlacement) {
        RangeHighlighter marker = this.createLineMarker(type, line, separatorPlacement);
        if (marker != null) {
            this.saveHighlighter(marker);
        }
    }

    void setSeparatorMarker(int line, Consumer<Integer> consumer) {
        EditorEx editor = this.getEditor();
        MarkupModel markupModel = this.getMarkupModel();
        if (editor == null || markupModel == null) {
            return;
        }
        RangeHighlighter marker = markupModel.addLineHighlighter(line, 5999, null);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        FragmentBoundRenderer renderer = new FragmentBoundRenderer(editor.getLineHeight(), editor, consumer);
        marker.setLineSeparatorColor(renderer.getColor());
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        this.myExtraHighLighters.add(marker);
    }

    @Nullable
    private RangeHighlighter createLineMarker(final @Nullable TextDiffType type, int line, SeparatorPlacement placement) {
        MarkupModel markupModel = this.getMarkupModel();
        Document document = this.getDocument();
        if (markupModel == null || document == null || type == null) {
            return null;
        }
        final Color color = this.getLineSeparatorColorForType(type);
        if (color == null) {
            return null;
        }
        RangeHighlighter marker = markupModel.addLineHighlighter(line, 5999, null);
        marker.setLineSeparatorColor(color);
        marker.setLineSeparatorPlacement(placement);
        marker.setLineSeparatorRenderer(new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                if (type.isInlineWrapper()) {
                    UIUtil.drawLine((Graphics2D)((Graphics2D)g), (int)x1, (int)y, (int)x2, (int)y, null, (Color)DiffUtil.getFramingColor(color));
                } else {
                    DiffUtil.drawDoubleShadowedLine((Graphics2D)g, x1, x2, y, color);
                }
            }
        });
        return marker;
    }

    @Nullable
    private Color getLineSeparatorColorForType(@NotNull TextDiffType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "getLineSeparatorColorForType"));
        }
        EditorEx editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        return type.getPolygonColor(editor);
    }

    private void saveHighlighter(@NotNull RangeHighlighter marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "saveHighlighter"));
        }
        this.myHighLighters.add(marker);
    }

    @Nullable
    public Document getDocument() {
        EditorEx editor = this.getEditor();
        return editor == null ? null : editor.getDocument();
    }

    public void addAction(@Nullable MergeOperations.Operation operation, int lineStartOffset) {
        RangeHighlighter highlighter = this.createAction(operation, lineStartOffset);
        if (highlighter != null) {
            this.myActionHighlighters.add((Object)highlighter);
        }
    }

    @Nullable
    private RangeHighlighter createAction(@Nullable MergeOperations.Operation operation, int lineStartOffset) {
        MarkupModel markupModel = this.getMarkupModel();
        if (operation == null || markupModel == null) {
            return null;
        }
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(lineStartOffset, lineStartOffset, 3000, new TextAttributes(null, null, null, null, 0), HighlighterTargetArea.LINES_IN_RANGE);
        MergeActionGroup.OperationAction action = new MergeActionGroup.OperationAction(operation);
        highlighter.setGutterIconRenderer((GutterIconRenderer)new GutterActionRenderer(action));
        return highlighter;
    }

    public void resetHighlighters() {
        this.removeHighlighters(this.myHighLighters);
        this.removeHighlighters((Collection<RangeHighlighter>)this.myActionHighlighters);
        for (RangeHighlighter highLighter : this.myExtraHighLighters) {
            highLighter.dispose();
        }
        this.myExtraHighLighters.clear();
    }

    private void removeHighlighters(@NotNull Collection<RangeHighlighter> highlighters) {
        if (highlighters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighters", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "removeHighlighters"));
        }
        MarkupModel markupModel = this.getMarkupModel();
        if (markupModel != null) {
            for (RangeHighlighter highlighter : highlighters) {
                highlighter.dispose();
            }
        }
        highlighters.clear();
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected void runRegisteredDisposables() {
        this.resetHighlighters();
        for (Disposable runnable : this.myDisposables) {
            Disposer.dispose((Disposable)runnable);
        }
        this.myDisposables.clear();
    }

    @Override
    public void addDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/diff/impl/highlighting/DiffMarkup", "addDisposable"));
        }
        Disposer.register((Disposable)this, (Disposable)disposable);
        this.myDisposables.add(disposable);
    }

    @Nullable
    public String getText() {
        Document document = this.getDocument();
        return document == null ? null : document.getText();
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.onDisposed();
        this.myDisposed = true;
    }

    protected void onDisposed() {
    }

    public void removeActions() {
        this.removeHighlighters((Collection<RangeHighlighter>)this.myActionHighlighters);
    }
}

