/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModelImpl
implements SelectionModel,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.SelectionModelImpl");
    private final List<SelectionListener> mySelectionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EditorImpl myEditor;
    private TextAttributes myTextAttributes;
    private LogicalPosition myBlockStart;
    private LogicalPosition myBlockEnd;
    private int[] myBlockSelectionStarts;
    private int[] myBlockSelectionEnds;
    private DocumentEvent myIsInUpdate;

    public SelectionModelImpl(EditorImpl editor) {
        this.myEditor = editor;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myIsInUpdate = event;
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            ((CaretImpl)caret).beforeDocumentChange();
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.myIsInUpdate == event) {
            this.myIsInUpdate = null;
            this.myEditor.getCaretModel().doWithCaretMerging(new Runnable(){

                @Override
                public void run() {
                    for (Caret caret : SelectionModelImpl.this.myEditor.getCaretModel().getAllCarets()) {
                        ((CaretImpl)caret).documentChanged();
                    }
                }
            });
        }
    }

    @Override
    public int getPriority() {
        return 140;
    }

    public boolean isUnknownDirection() {
        return this.myEditor.getCaretModel().getCurrentCaret().isUnknownDirection();
    }

    public void setUnknownDirection(boolean unknownDirection) {
        this.myEditor.getCaretModel().getCurrentCaret().setUnknownDirection(unknownDirection);
    }

    public int getSelectionStart() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionStart();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myEditor.getCaretModel().getCurrentCaret().getSelectionStartPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getSelectionStartPosition"));
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectionEnd();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myEditor.getCaretModel().getCurrentCaret().getSelectionEndPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getSelectionEndPosition"));
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.hasSelection(false);
    }

    public boolean hasSelection(boolean anyCaret) {
        if (!anyCaret) {
            return this.myEditor.getCaretModel().getCurrentCaret().hasSelection();
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            if (!caret.hasSelection()) continue;
            return true;
        }
        return false;
    }

    public void setSelection(int startOffset, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.myEditor.getCaretModel().getCurrentCaret().setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    void fireSelectionChanged(int oldSelectionStart, int oldSelectionEnd, int startOffset, int endOffset) {
        this.repaintBySelectionChange(oldSelectionStart, startOffset, oldSelectionEnd, endOffset);
        SelectionEvent event = new SelectionEvent((Editor)this.myEditor, oldSelectionStart, oldSelectionEnd, startOffset, endOffset);
        this.broadcastSelectionEvent(event);
    }

    private void broadcastSelectionEvent(SelectionEvent event) {
        for (SelectionListener listener : this.mySelectionListeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void repaintBySelectionChange(int oldSelectionStart, int startOffset, int oldSelectionEnd, int endOffset) {
        this.myEditor.repaint(Math.min(oldSelectionStart, startOffset), Math.max(oldSelectionStart, startOffset));
        this.myEditor.repaint(Math.min(oldSelectionEnd, endOffset), Math.max(oldSelectionEnd, endOffset));
    }

    public void removeSelection() {
        this.removeSelection(false);
    }

    public void removeSelection(boolean allCarets) {
        if (!allCarets) {
            this.myEditor.getCaretModel().getCurrentCaret().removeSelection();
        } else {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caret.removeSelection();
            }
        }
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStart", "com/intellij/openapi/editor/impl/SelectionModelImpl", "setBlockSelection"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "com/intellij/openapi/editor/impl/SelectionModelImpl", "setBlockSelection"));
        }
        if (this.myEditor.getCaretModel().supportsMultipleCarets()) {
            int startLine = Math.max(Math.min(blockStart.line, this.myEditor.getDocument().getLineCount() - 1), 0);
            int endLine = Math.max(Math.min(blockEnd.line, this.myEditor.getDocument().getLineCount() - 1), 0);
            int step = endLine < startLine ? -1 : 1;
            int count = 1 + Math.abs(endLine - startLine);
            LinkedList<CaretState> caretStates = new LinkedList<CaretState>();
            boolean hasSelection = false;
            int line = startLine;
            int i = 0;
            while (i < count) {
                int startColumn = blockStart.column;
                int endColumn = blockEnd.column;
                int lineEndOffset = this.myEditor.getDocument().getLineEndOffset(line);
                LogicalPosition lineEndPosition = this.myEditor.offsetToLogicalPosition(lineEndOffset);
                int lineWidth = lineEndPosition.column;
                if (startColumn > lineWidth && endColumn > lineWidth && !this.myEditor.isColumnMode()) {
                    LogicalPosition caretPos = new LogicalPosition(line, Math.min(startColumn, endColumn));
                    caretStates.add(new CaretState(caretPos, lineEndPosition, lineEndPosition));
                } else {
                    LogicalPosition startPos = new LogicalPosition(line, this.myEditor.isColumnMode() ? startColumn : Math.min(startColumn, lineWidth));
                    LogicalPosition endPos = new LogicalPosition(line, this.myEditor.isColumnMode() ? endColumn : Math.min(endColumn, lineWidth));
                    int startOffset = this.myEditor.logicalPositionToOffset(startPos);
                    int endOffset = this.myEditor.logicalPositionToOffset(endPos);
                    caretStates.add(new CaretState(endPos, startPos, endPos));
                    hasSelection |= startOffset != endOffset;
                }
                ++i;
                line += step;
            }
            if (hasSelection && !this.myEditor.isColumnMode()) {
                Iterator caretStateIterator = caretStates.iterator();
                while (caretStateIterator.hasNext()) {
                    CaretState state = (CaretState)caretStateIterator.next();
                    if (!state.getSelectionStart().equals((Object)state.getSelectionEnd())) continue;
                    caretStateIterator.remove();
                }
            }
            this.myEditor.getCaretModel().setCaretsAndSelections(caretStates);
        } else {
            int newEndLine;
            int newStartLine;
            this.removeSelection();
            int oldStartLine = 0;
            int oldEndLine = 0;
            if (this.hasBlockSelection() && (oldStartLine = this.myBlockStart.line) > (oldEndLine = this.myBlockEnd.line)) {
                int t = oldStartLine;
                oldStartLine = oldEndLine;
                oldEndLine = t;
            }
            if ((newStartLine = blockStart.line) > (newEndLine = blockEnd.line)) {
                int t = newStartLine;
                newStartLine = newEndLine;
                newEndLine = t;
            }
            this.myEditor.repaintLines(Math.min(oldStartLine, newStartLine), Math.max(newEndLine, oldEndLine));
            int[] oldStarts = this.getBlockSelectionStarts();
            int[] oldEnds = this.getBlockSelectionEnds();
            this.myBlockStart = blockStart;
            this.myBlockEnd = blockEnd;
            this.recalculateBlockOffsets();
            int[] newStarts = this.getBlockSelectionStarts();
            int[] newEnds = this.getBlockSelectionEnds();
            this.broadcastSelectionEvent(new SelectionEvent((Editor)this.myEditor, oldStarts, oldEnds, newStarts, newEnds));
        }
    }

    public void removeBlockSelection() {
        if (!this.myEditor.getCaretModel().supportsMultipleCarets()) {
            this.myEditor.getCaretModel().getCurrentCaret().setUnknownDirection(false);
            if (this.hasBlockSelection()) {
                this.myEditor.repaint(0, this.myEditor.getDocument().getTextLength());
                int[] oldStarts = this.getBlockSelectionStarts();
                int[] oldEnds = this.getBlockSelectionEnds();
                this.myBlockStart = null;
                this.myBlockEnd = null;
                int[] newStarts = this.getBlockSelectionStarts();
                int[] newEnds = this.getBlockSelectionEnds();
                this.broadcastSelectionEvent(new SelectionEvent((Editor)this.myEditor, oldStarts, oldEnds, newStarts, newEnds));
            }
        }
    }

    public boolean hasBlockSelection() {
        return this.myBlockStart != null;
    }

    public LogicalPosition getBlockStart() {
        return this.myBlockStart;
    }

    public LogicalPosition getBlockEnd() {
        return this.myBlockEnd;
    }

    public boolean isBlockSelectionGuarded() {
        if (!this.hasBlockSelection()) {
            return false;
        }
        int[] starts = this.getBlockSelectionStarts();
        int[] ends = this.getBlockSelectionEnds();
        DocumentEx doc = this.myEditor.getDocument();
        for (int i = 0; i < starts.length; ++i) {
            int start = starts[i];
            int end = ends[i];
            if ((start != end || doc.getOffsetGuard(start) == null) && (start == end || doc.getRangeGuard(start, end) == null)) continue;
            return true;
        }
        return false;
    }

    public RangeMarker getBlockSelectionGuard() {
        if (!this.hasBlockSelection()) {
            return null;
        }
        int[] starts = this.getBlockSelectionStarts();
        int[] ends = this.getBlockSelectionEnds();
        DocumentEx doc = this.myEditor.getDocument();
        for (int i = 0; i < starts.length; ++i) {
            RangeMarker guard;
            int start = starts[i];
            int end = ends[i];
            if (start == end && (guard = doc.getOffsetGuard(start)) != null) {
                return guard;
            }
            if (start == end || (guard = doc.getRangeGuard(start, end)) == null) continue;
            return guard;
        }
        return null;
    }

    private void recalculateBlockOffsets() {
        TIntArrayList startOffsets = new TIntArrayList();
        TIntArrayList endOffsets = new TIntArrayList();
        int startLine = Math.min(this.myBlockStart.line, this.myBlockEnd.line);
        int endLine = Math.max(this.myBlockStart.line, this.myBlockEnd.line);
        int startColumn = Math.min(this.myBlockStart.column, this.myBlockEnd.column);
        int endColumn = Math.max(this.myBlockStart.column, this.myBlockEnd.column);
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        DocumentEx document = this.myEditor.getDocument();
        boolean insideFoldRegion = false;
        for (int line = startLine; line <= endLine; ++line) {
            boolean endInsideFold;
            int startOffset = this.myEditor.logicalPositionToOffset(new LogicalPosition(line, startColumn));
            FoldRegion startRegion = foldingModel.getCollapsedRegionAtOffset(startOffset);
            boolean startInsideFold = startRegion != null && startRegion.getStartOffset() < startOffset;
            int endOffset = this.myEditor.logicalPositionToOffset(new LogicalPosition(line, endColumn));
            FoldRegion endRegion = foldingModel.getCollapsedRegionAtOffset(endOffset);
            boolean bl = endInsideFold = endRegion != null && endRegion.getStartOffset() < endOffset;
            if (!startInsideFold && !endInsideFold) {
                startOffsets.add(startOffset);
                endOffsets.add(endOffset);
                continue;
            }
            if (startInsideFold && endInsideFold) {
                if (!insideFoldRegion) continue;
                startOffsets.add(Math.max(document.getLineStartOffset(line), startRegion.getStartOffset()));
                endOffsets.add(Math.min(document.getLineEndOffset(line), endRegion.getEndOffset()));
                continue;
            }
            if (startInsideFold && !endInsideFold) {
                if (startRegion.getEndOffset() < endOffset) {
                    startOffsets.add(Math.max(document.getLineStartOffset(line), startRegion.getStartOffset()));
                    endOffsets.add(endOffset);
                }
                insideFoldRegion = false;
                continue;
            }
            startOffsets.add(startOffset);
            endOffsets.add(Math.min(document.getLineEndOffset(line), endRegion.getEndOffset()));
            insideFoldRegion = true;
        }
        this.myBlockSelectionStarts = startOffsets.toNativeArray();
        this.myBlockSelectionEnds = endOffsets.toNativeArray();
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        if (this.myEditor.getCaretModel().supportsMultipleCarets()) {
            List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
            int[] result = new int[carets.size()];
            int i = 0;
            for (Caret caret : carets) {
                result[i++] = caret.getSelectionStart();
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionStarts"));
            }
            return result;
        }
        if (this.hasSelection()) {
            int[] nArray = new int[]{this.getSelectionStart()};
            if (nArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionStarts"));
            }
            return nArray;
        }
        if (!this.hasBlockSelection() || this.myBlockSelectionStarts == null) {
            if (ArrayUtil.EMPTY_INT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionStarts"));
            }
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        if (this.myBlockSelectionStarts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionStarts"));
        }
        return this.myBlockSelectionStarts;
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        if (this.myEditor.getCaretModel().supportsMultipleCarets()) {
            List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
            int[] result = new int[carets.size()];
            int i = 0;
            for (Caret caret : carets) {
                result[i++] = caret.getSelectionEnd();
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionEnds"));
            }
            return result;
        }
        if (this.hasSelection()) {
            int[] nArray = new int[]{this.getSelectionEnd()};
            if (nArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionEnds"));
            }
            return nArray;
        }
        if (!this.hasBlockSelection() || this.myBlockSelectionEnds == null) {
            if (ArrayUtil.EMPTY_INT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionEnds"));
            }
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        if (this.myBlockSelectionEnds == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getBlockSelectionEnds"));
        }
        return this.myBlockSelectionEnds;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mySelectionListeners.add(listener);
    }

    public void addSelectionListener(final SelectionListener listener, Disposable parent) {
        this.mySelectionListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                SelectionModelImpl.this.mySelectionListeners.remove(listener);
            }
        });
    }

    public void removeSelectionListener(SelectionListener listener) {
        boolean success = this.mySelectionListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public String getSelectedText() {
        return this.getSelectedText(false);
    }

    public String getSelectedText(boolean allCarets) {
        this.validateContext(false);
        if (this.hasBlockSelection()) {
            CharSequence text = this.myEditor.getDocument().getCharsSequence();
            int[] starts = this.getBlockSelectionStarts();
            int[] ends = this.getBlockSelectionEnds();
            int width = this.myEditor.getCaretModel().supportsMultipleCarets() ? 0 : Math.abs(this.myBlockEnd.column - this.myBlockStart.column);
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < starts.length; ++i) {
                if (i > 0) {
                    buf.append('\n');
                }
                int len = ends[i] - starts[i];
                SelectionModelImpl.appendCharSequence(buf, text, starts[i], len);
                for (int j = len; j < width; ++j) {
                    buf.append(' ');
                }
            }
            return buf.toString();
        }
        if (this.myEditor.getCaretModel().supportsMultipleCarets() && allCarets) {
            StringBuilder buf = new StringBuilder();
            String separator = "";
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                buf.append(separator);
                String caretSelectedText = caret.getSelectedText();
                if (caretSelectedText != null) {
                    buf.append(caretSelectedText);
                }
                separator = "\n";
            }
            return buf.toString();
        }
        return this.myEditor.getCaretModel().getCurrentCaret().getSelectedText();
    }

    private static void appendCharSequence(@NotNull StringBuilder buf, @NotNull CharSequence s, int srcOffset, int len) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/openapi/editor/impl/SelectionModelImpl", "appendCharSequence"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/SelectionModelImpl", "appendCharSequence"));
        }
        if (srcOffset < 0 || len < 0 || srcOffset > s.length() - len) {
            throw new IndexOutOfBoundsException("srcOffset " + srcOffset + ", len " + len + ", s.length() " + s.length());
        }
        if (len == 0) {
            return;
        }
        int limit = srcOffset + len;
        for (int i = srcOffset; i < limit; ++i) {
            buf.append(s.charAt(i));
        }
    }

    public static void doSelectLineAtCaret(Editor editor) {
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        Document document = editor.getDocument();
        if (lineNumber >= document.getLineCount()) {
            return;
        }
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcCaretLineRange(editor);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        editor.getSelectionModel().setSelection(start, end);
    }

    public int getLeadSelectionOffset() {
        return this.myEditor.getCaretModel().getCurrentCaret().getLeadSelectionOffset();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myEditor.getCaretModel().getCurrentCaret().getLeadSelectionPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SelectionModelImpl", "getLeadSelectionPosition"));
        }
        return visualPosition;
    }

    public void selectLineAtCaret() {
        this.myEditor.getCaretModel().getCurrentCaret().selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myEditor.getCaretModel().getCurrentCaret().selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard() {
        EditorCopyPasteHelper.getInstance().copySelectionToClipboard((Editor)this.myEditor);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            TextAttributes textAttributes = new TextAttributes();
            EditorColorsScheme scheme = this.myEditor.getColorsScheme();
            textAttributes.setForegroundColor(scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            textAttributes.setBackgroundColor(scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            this.myTextAttributes = textAttributes;
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    private void validateContext(boolean isWrite) {
        if (!this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (isWrite) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        } else {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
    }
}

