/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesOnServerTracker;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class RemoteRevisionsStateCache
implements ChangesOnServerTracker {
    private static final long DISCRETE = 3600000L;
    private final Map<String, Pair<Boolean, VcsRoot>> myChanged;
    private final MultiMap<VcsRoot, String> myQueries;
    private final Map<VcsRoot, Long> myTs;
    private final Object myLock;
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsConfiguration myVcsConfiguration;

    RemoteRevisionsStateCache(Project project) {
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myChanged = new HashMap<String, Pair<Boolean, VcsRoot>>();
        this.myQueries = new MultiMap();
        this.myTs = new HashMap<VcsRoot, Long>();
        this.myLock = new Object();
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Collection<String> paths) {
        Object object = this.myLock;
        synchronized (object) {
            for (String path : paths) {
                this.myChanged.remove(path);
            }
        }
    }

    @Nullable
    private VirtualFile getRootForPath(String s) {
        return this.myVcsManager.getVcsRootFor((FilePath)new FilePathImpl(new File(s), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate(Change change) {
        List files = ChangesUtil.getIoFilesFromChanges(Collections.singletonList(change));
        Object object = this.myLock;
        synchronized (object) {
            for (File file : files) {
                String path = file.getAbsolutePath();
                Pair<Boolean, VcsRoot> data = this.myChanged.get(path);
                if (data == null || !Boolean.TRUE.equals(data.getFirst())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plus(Pair<String, AbstractVcs> pair) {
        VirtualFile root = this.getRootForPath((String)pair.getFirst());
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueries.putValue((Object)new VcsRoot((AbstractVcs)pair.getSecond(), root), pair.getFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void minus(Pair<String, AbstractVcs> pair) {
        VirtualFile root = this.getRootForPath((String)pair.getFirst());
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            VcsRoot key = new VcsRoot((AbstractVcs)pair.getSecond(), root);
            if (this.myQueries.containsKey((Object)key)) {
                this.myQueries.remove((Object)key, pair.getFirst());
            }
            this.myChanged.remove(pair.getFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChanged.clear();
            this.myTs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStep() {
        MultiMap dirty = new MultiMap();
        long oldPoint = System.currentTimeMillis() - (this.myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL > 0 ? (long)(this.myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL * 60000) : 3600000L);
        Object object = this.myLock;
        synchronized (object) {
            for (VcsRoot root : this.myQueries.keySet()) {
                Collection object2 = this.myQueries.get((Object)root);
                for (String s : object2) {
                    dirty.putValue((Object)root, (Object)s);
                }
            }
            this.myQueries.clear();
            HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
            for (Map.Entry<VcsRoot, Long> entry : this.myTs.entrySet()) {
                Long ts;
                if (!dirty.get((Object)entry.getKey()).isEmpty() || (ts = entry.getValue()) != null && oldPoint <= ts) continue;
                roots.add(entry.getKey());
            }
            for (Map.Entry<Object, Long> entry : this.myChanged.entrySet()) {
                VcsRoot vcsRoot = (VcsRoot)((Pair)entry.getValue()).getSecond();
                if (dirty.get((Object)vcsRoot).isEmpty() && !roots.contains(vcsRoot)) continue;
                dirty.putValue((Object)vcsRoot, entry.getKey());
            }
        }
        if (dirty.isEmpty()) {
            return false;
        }
        HashMap<String, Pair> results = new HashMap<String, Pair>();
        for (VcsRoot vcsRoot : dirty.keySet()) {
            TreeDiffProvider treeDiffProvider;
            if (!vcsRoot.getVcs().isVcsBackgroundOperationsAllowed(vcsRoot.getPath()) || (treeDiffProvider = vcsRoot.getVcs().getTreeDiffProvider()) == null) continue;
            Collection paths = dirty.get((Object)vcsRoot);
            Collection remotelyChanged = treeDiffProvider.getRemotelyChanged(vcsRoot.getPath(), paths);
            for (String path : paths) {
                results.put(path, new Pair((Object)remotelyChanged.contains(path), (Object)vcsRoot));
            }
        }
        long curTime = System.currentTimeMillis();
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myChanged.putAll(results);
            for (VcsRoot vcsRoot : dirty.keySet()) {
                this.myTs.put(vcsRoot, curTime);
            }
        }
        return true;
    }
}

