/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsBackgroundableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryProviderBackgroundableProxy {
    private final Project myProject;
    private final DiffProvider myDiffProvider;
    private final VcsHistoryProvider myDelegate;
    private VcsHistoryCache myVcsHistoryCache;
    private boolean myCachesHistory;
    private final HistoryComputerFactory myHistoryComputerFactory;
    private final VcsType myType;
    private VcsConfiguration myConfiguration;

    public VcsHistoryProviderBackgroundableProxy(AbstractVcs vcs, VcsHistoryProvider delegate, DiffProvider diffProvider) {
        this.myDelegate = delegate;
        this.myProject = vcs.getProject();
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myCachesHistory = this.myDelegate instanceof VcsCacheableHistorySessionFactory;
        this.myDiffProvider = diffProvider;
        this.myVcsHistoryCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myType = vcs.getType();
        this.myHistoryComputerFactory = new HistoryComputerFactory(){

            @Override
            public ThrowableComputable<VcsHistorySession, VcsException> create(FilePath filePath, Consumer<VcsHistorySession> consumer, VcsKey vcsKey) {
                if (VcsHistoryProviderBackgroundableProxy.this.myCachesHistory) {
                    return new CachingHistoryComputer(filePath, consumer, vcsKey);
                }
                return new SimpelHistoryComputer(filePath, consumer);
            }
        };
    }

    public void createSessionFor(VcsKey vcsKey, FilePath filePath, Consumer<VcsHistorySession> continuation, @Nullable VcsBackgroundableActions actionKey, boolean silent, @Nullable Consumer<VcsHistorySession> backgroundSpecialization) {
        ThrowableComputable<VcsHistorySession, VcsException> throwableComputable = this.myHistoryComputerFactory.create(filePath, backgroundSpecialization, vcsKey);
        VcsBackgroundableActions resultingActionKey = actionKey == null ? VcsBackgroundableActions.CREATE_HISTORY_SESSION : actionKey;
        Object key = VcsBackgroundableActions.keyFrom(filePath);
        if (silent) {
            VcsBackgroundableComputable.createAndRunSilent(this.myProject, resultingActionKey, key, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), throwableComputable, continuation);
        } else {
            VcsBackgroundableComputable.createAndRun(this.myProject, resultingActionKey, key, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), throwableComputable, continuation, null);
        }
    }

    public void executeAppendableSession(final VcsKey vcsKey, final FilePath filePath, VcsAppendableHistorySessionPartner partner, @Nullable VcsBackgroundableActions actionKey, boolean canUseCache, boolean canUseLastRevisionCheck) {
        VcsBackgroundableActions resultingActionKey;
        VcsAbstractHistorySession session;
        if (this.myCachesHistory && canUseCache && (session = this.getFullHistoryFromCache(vcsKey, filePath)) != null) {
            partner.reportCreatedEmptySession(session);
            partner.finished();
            partner.forceRefresh();
            return;
        }
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
        BackgroundableActionEnabledHandler handler = vcsManager.getBackgroundableActionHandler(resultingActionKey = actionKey == null ? VcsBackgroundableActions.CREATE_HISTORY_SESSION : actionKey);
        if (handler.isInProgress((Object)resultingActionKey)) {
            return;
        }
        handler.register((Object)resultingActionKey);
        VcsAppendableHistorySessionPartner cachedPartner = this.myCachesHistory ? new HistoryPartnerProxy(partner, (Consumer)new Consumer<VcsAbstractHistorySession>(){

            public void consume(VcsAbstractHistorySession session) {
                if (session == null) {
                    return;
                }
                FilePath correctedPath = ((VcsCacheableHistorySessionFactory)VcsHistoryProviderBackgroundableProxy.this.myDelegate).getUsedFilePath(session);
                VcsHistoryProviderBackgroundableProxy.this.myVcsHistoryCache.put(filePath, correctedPath, vcsKey, (VcsAbstractHistorySession)session.copy(), (VcsCacheableHistorySessionFactory)VcsHistoryProviderBackgroundableProxy.this.myDelegate, true);
            }
        }) : partner;
        this.reportHistory(filePath, vcsKey, resultingActionKey, handler, cachedPartner, canUseLastRevisionCheck);
    }

    private VcsAbstractHistorySession getFullHistoryFromCache(VcsKey vcsKey, FilePath filePath) {
        VcsAbstractHistorySession full = this.myVcsHistoryCache.getFull(filePath, vcsKey, (VcsCacheableHistorySessionFactory)this.myDelegate);
        if (full != null && this.myConfiguration.LIMIT_HISTORY && this.myConfiguration.MAXIMUM_HISTORY_ROWS < full.getRevisionList().size()) {
            List list = full.getRevisionList();
            ArrayList was = new ArrayList(list.subList(0, this.myConfiguration.MAXIMUM_HISTORY_ROWS));
            list.clear();
            list.addAll(was);
        }
        return full;
    }

    private void reportHistory(final FilePath filePath, final VcsKey vcsKey, final VcsBackgroundableActions resultingActionKey, final BackgroundableActionEnabledHandler handler, final VcsAppendableHistorySessionPartner cachedPartner, final boolean canUseLastRevisionCheck) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                block7: {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/VcsHistoryProviderBackgroundableProxy$3", "run"));
                    }
                    if (indicator != null) {
                        indicator.setText(VcsUtil.getPathForProgressPresentation((File)filePath.getIOFile()));
                    }
                    try {
                        VcsHistorySession cachedSession = null;
                        if (canUseLastRevisionCheck && VcsHistoryProviderBackgroundableProxy.this.myCachesHistory && (cachedSession = VcsHistoryProviderBackgroundableProxy.this.getSessionFromCacheWithLastRevisionCheck(filePath, vcsKey)) != null) {
                            cachedPartner.reportCreatedEmptySession((VcsAbstractHistorySession)cachedSession);
                            break block7;
                        }
                        VcsHistoryProviderBackgroundableProxy.this.myDelegate.reportAppendableHistory(filePath, cachedPartner);
                    }
                    catch (VcsException e) {
                        try {
                            cachedPartner.reportException(e);
                        }
                        catch (Throwable throwable) {
                            cachedPartner.finished();
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    handler.completed((Object)resultingActionKey);
                                }
                            }, ModalityState.NON_MODAL);
                            throw throwable;
                        }
                        cachedPartner.finished();
                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                    }
                }
                cachedPartner.finished();
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
            }
        });
    }

    private VcsHistorySession createSessionWithLimitCheck(FilePath filePath) throws VcsException {
        VcsAppendableHistoryPartnerAdapter partner;
        block2: {
            final LimitHistoryCheck check = new LimitHistoryCheck(this.myProject, filePath.getPath());
            partner = new VcsAppendableHistoryPartnerAdapter(){

                public void acceptRevision(VcsFileRevision revision) {
                    check.checkNumber();
                    super.acceptRevision(revision);
                }
            };
            try {
                this.myDelegate.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)partner);
            }
            catch (ProcessCanceledException e) {
                if (check.isOver()) break block2;
                throw e;
            }
        }
        return partner.getSession();
    }

    @Nullable
    private VcsHistorySession getSessionFromCacheWithLastRevisionCheck(FilePath filePath, VcsKey vcsKey) {
        VcsAbstractHistorySession cached;
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setText2("Checking last revision");
        }
        if ((cached = this.getFullHistoryFromCache(vcsKey, filePath)) == null) {
            return null;
        }
        FilePath correctedFilePath = ((VcsCacheableHistorySessionFactory)this.myDelegate).getUsedFilePath(cached);
        if (VcsType.distributed.equals((Object)this.myType)) {
            FilePath path = correctedFilePath != null ? correctedFilePath : filePath;
            path.hardRefresh();
            VirtualFile virtualFile = path.getVirtualFile();
            if (virtualFile != null) {
                VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(virtualFile);
                List revisionList = cached.getRevisionList();
                if (!revisionList.isEmpty() && ((VcsFileRevision)revisionList.get(0)).getRevisionNumber().equals(currentRevision)) {
                    return cached;
                }
            }
        } else {
            List revisionList;
            ItemLatestState lastRevision = this.myDiffProvider.getLastRevision(correctedFilePath != null ? correctedFilePath : filePath);
            if (lastRevision != null && !lastRevision.isDefaultHead() && lastRevision.isItemExists() && !(revisionList = cached.getRevisionList()).isEmpty() && ((VcsFileRevision)revisionList.get(0)).getRevisionNumber().equals(lastRevision.getNumber())) {
                return cached;
            }
        }
        return null;
    }

    private class CachingHistoryComputer
    implements ThrowableComputable<VcsHistorySession, VcsException> {
        private final FilePath myFilePath;
        private final Consumer<VcsHistorySession> myConsumer;
        private final VcsKey myVcsKey;

        private CachingHistoryComputer(FilePath filePath, Consumer<VcsHistorySession> consumer, VcsKey vcsKey) {
            this.myFilePath = filePath;
            this.myConsumer = consumer;
            this.myVcsKey = vcsKey;
        }

        public VcsHistorySession compute() throws VcsException {
            VcsHistorySession session = null;
            session = VcsHistoryProviderBackgroundableProxy.this.getSessionFromCacheWithLastRevisionCheck(this.myFilePath, this.myVcsKey);
            if (session == null) {
                session = VcsHistoryProviderBackgroundableProxy.this.createSessionWithLimitCheck(this.myFilePath);
                FilePath correctedPath = ((VcsCacheableHistorySessionFactory)VcsHistoryProviderBackgroundableProxy.this.myDelegate).getUsedFilePath((VcsAbstractHistorySession)session);
                VcsHistoryProviderBackgroundableProxy.this.myVcsHistoryCache.put(this.myFilePath, correctedPath, this.myVcsKey, (VcsAbstractHistorySession)((VcsAbstractHistorySession)session).copy(), (VcsCacheableHistorySessionFactory)VcsHistoryProviderBackgroundableProxy.this.myDelegate, true);
            }
            if (this.myConsumer != null) {
                this.myConsumer.consume((Object)session);
            }
            return session;
        }
    }

    private class SimpelHistoryComputer
    implements ThrowableComputable<VcsHistorySession, VcsException> {
        private final FilePath myFilePath;
        private final Consumer<VcsHistorySession> myConsumer;

        private SimpelHistoryComputer(FilePath filePath, Consumer<VcsHistorySession> consumer) {
            this.myFilePath = filePath;
            this.myConsumer = consumer;
        }

        public VcsHistorySession compute() throws VcsException {
            VcsHistorySession session = VcsHistoryProviderBackgroundableProxy.this.createSessionWithLimitCheck(this.myFilePath);
            if (this.myConsumer != null) {
                this.myConsumer.consume((Object)session);
            }
            return session;
        }
    }

    private static interface HistoryComputerFactory {
        public ThrowableComputable<VcsHistorySession, VcsException> create(FilePath var1, Consumer<VcsHistorySession> var2, VcsKey var3);
    }

    private static class HistoryPartnerProxy
    implements VcsAppendableHistorySessionPartner {
        private final VcsAppendableHistorySessionPartner myPartner;
        private final Consumer<VcsAbstractHistorySession> myFinish;
        private VcsAbstractHistorySession myCopy;

        private HistoryPartnerProxy(VcsAppendableHistorySessionPartner partner, Consumer<VcsAbstractHistorySession> finish) {
            this.myPartner = partner;
            this.myFinish = finish;
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session) {
            this.myCopy = (VcsAbstractHistorySession)session.copy();
            this.myPartner.reportCreatedEmptySession(session);
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCopy.appendRevision(revision);
            this.myPartner.acceptRevision(revision);
        }

        public void reportException(VcsException exception) {
            this.myPartner.reportException(exception);
        }

        public void finished() {
            this.myPartner.finished();
            this.myFinish.consume((Object)this.myCopy);
        }

        public void beforeRefresh() {
            this.myPartner.beforeRefresh();
        }

        public void forceRefresh() {
            this.myPartner.forceRefresh();
        }
    }
}

