/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JDTag {
    SEE("see"),
    AUTHOR("author"),
    VERSION("version"),
    THROWS("throws"),
    EXCEPTION("exception"),
    RETURN("return"),
    PARAM("param"),
    SINCE("since"),
    DEPRECATED("deprecated");

    @NotNull
    private final String myTag;

    private JDTag(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/codeStyle/javadoc/JDTag", "<init>"));
        }
        this.myTag = tag;
    }

    @NotNull
    public String getDescriptionPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDTag", "getDescriptionPrefix"));
        }
        String string = prefix + StringUtil.repeatSymbol((char)' ', (int)this.getWithEndWhitespace().length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDTag", "getDescriptionPrefix"));
        }
        return string;
    }

    @NotNull
    public String getWithEndWhitespace() {
        String string = "@" + this.myTag + " ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDTag", "getWithEndWhitespace"));
        }
        return string;
    }

    public boolean tagEqual(@Nullable String tag) {
        return this.myTag.equals(tag);
    }
}

