/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangClassMemberReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangClassMemberReference(PsiLiteralExpression literal, PsiExpression context) {
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "bindToElement"));
        }
        return element;
    }

    public PsiElement resolve() {
        PsiClass psiClass;
        String name = (String)((PsiLiteralExpression)this.getElement()).getValue();
        Type type = this.getType();
        if (type != null && (psiClass = this.getPsiClass()) != null) {
            PsiMethod[] methods;
            Object member = type == Type.FIELD || type == Type.DECLARED_FIELD ? psiClass.findFieldByName(name, false) : ((methods = psiClass.findMethodsByName(name, false)).length == 0 ? null : methods[0]);
            return member;
        }
        return null;
    }

    @Nullable
    private PsiClass getPsiClass() {
        Object value;
        PsiExpression[] expressions;
        PsiMethod method;
        if (this.myContext instanceof PsiClassObjectAccessExpression) {
            return PsiTypesUtil.getPsiClass((PsiType)((PsiClassObjectAccessExpression)this.myContext).getOperand().getType());
        }
        if (this.myContext instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)this.myContext).resolveMethod()) != null && "forName".equals(method.getName()) && JavaLangClassMemberReference.isClass(method.getContainingClass()) && (expressions = ((PsiMethodCallExpression)this.myContext).getArgumentList().getExpressions()).length == 1 && expressions[0] instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)expressions[0]).getValue()) instanceof String) {
            Project project = this.myContext.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(String.valueOf(value), GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    private static boolean isClass(PsiClass aClass) {
        return aClass != null && "java.lang.Class".equals(aClass.getQualifiedName());
    }

    @Nullable
    private Type getType() {
        boolean selfFound = false;
        for (PsiElement child : this.myContext.getParent().getChildren()) {
            if (!selfFound) {
                if (child != this.myContext) continue;
                selfFound = true;
                continue;
            }
            if (!(child instanceof PsiIdentifier)) continue;
            return Type.fromString(child.getText());
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        Type type = this.getType();
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null && type != null) {
            if (type == Type.DECLARED_FIELD) {
                Object[] objectArray = psiClass.getFields();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                }
                return objectArray;
            }
            if (type == Type.FIELD) {
                ArrayList<PsiField> fields = new ArrayList<PsiField>();
                for (PsiField field : psiClass.getFields()) {
                    if (!JavaLangClassMemberReference.isPublic((PsiMember)field)) continue;
                    fields.add(field);
                }
                Object[] objectArray = fields.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                }
                return objectArray;
            }
            if (type == Type.DECLARED_METHOD || type == Type.METHOD) {
                ArrayList<LookupElementBuilder> elements = new ArrayList<LookupElementBuilder>();
                for (PsiMethod method : psiClass.getMethods()) {
                    if (type != Type.DECLARED_METHOD && !JavaLangClassMemberReference.isPublic((PsiMember)method)) continue;
                    elements.add(JavaLookupElementBuilder.forMethod(method, PsiSubstitutor.EMPTY).withInsertHandler((InsertHandler)this));
                }
                Object[] objectArray = elements.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                }
                return objectArray;
            }
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Object object = item.getObject();
        if (object instanceof PsiMethod) {
            PsiElement newElement = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
            int start = newElement.getTextRange().getEndOffset();
            PsiElement params = newElement.getParent().getParent();
            int end = params.getTextRange().getEndOffset() - 1;
            String types = JavaLangClassMemberReference.getMethodTypes((PsiMethod)object);
            context.getDocument().replaceString(start, end, (CharSequence)types);
            context.commitDocument();
            PsiElement firstParam = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstParam, PsiMethodCallExpression.class);
            if (methodCall != null) {
                JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)methodCall);
            }
        }
    }

    private static boolean isPublic(PsiMember psiField) {
        return psiField.hasModifierProperty("public");
    }

    private static String getMethodTypes(PsiMethod method) {
        StringBuilder buf = new StringBuilder();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            buf.append(", ").append(TypeConversionUtil.erasure((PsiType)parameter.getType()).getPresentableText()).append(".class");
        }
        return buf.toString();
    }

    static enum Type {
        FIELD,
        DECLARED_FIELD,
        METHOD,
        DECLARED_METHOD;


        @Nullable
        static Type fromString(String s) {
            if ("getField".equals(s)) {
                return FIELD;
            }
            if ("getDeclaredField".equals(s)) {
                return DECLARED_FIELD;
            }
            if ("getMethod".equals(s)) {
                return METHOD;
            }
            if ("getDeclaredMethod".equals(s)) {
                return DECLARED_METHOD;
            }
            return null;
        }
    }
}

