/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConvertToInstanceMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"convert.to.instance.method.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodHandler", "invoke"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MakeMethodStaticHandler invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodHandler", "invoke"));
        }
        if (elements.length != 1 || !(elements[0] instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)elements[0];
        if (!method.hasModifierProperty("static")) {
            String message = RefactoringBundle.message((String)"convertToInstanceMethod.method.is.not.static", (Object[])new Object[]{method.getName()});
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        ArrayList<PsiParameter> suitableParameters = new ArrayList<PsiParameter>();
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        boolean classesInProjectFound = false;
        for (PsiParameter parameter : parameters) {
            PsiType type = parameter.getType();
            if (!(type instanceof PsiClassType)) continue;
            classTypesFound = true;
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            boolean inProject = method.getManager().isInProject((PsiElement)psiClass);
            if (!inProject) continue;
            classesInProjectFound = true;
            suitableParameters.add(parameter);
        }
        if (suitableParameters.isEmpty()) {
            String message = null;
            if (!classTypesFound) {
                message = RefactoringBundle.message((String)"convertToInstanceMethod.no.parameters.with.reference.type");
            } else if (!resolvableClassesFound) {
                message = RefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parametres.have.unknown.types");
            } else if (!classesInProjectFound) {
                message = RefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parameters.are.not.in.project");
            }
            LOG.assertTrue(message != null);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message), (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        new ConvertToInstanceMethodDialog(method, suitableParameters.toArray(new PsiParameter[suitableParameters.size()])).show();
    }
}

