/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VagrantSupport {
    @Nullable
    public static VagrantSupport getInstance() {
        return (VagrantSupport)ServiceManager.getService(VagrantSupport.class);
    }

    @Nullable
    public abstract Pair<String, RemoteCredentials> getVagrantSettings(Project var1);

    @NotNull
    public abstract RemoteCredentials getVagrantSettings(@NotNull Project var1, String var2);

    public abstract void getVagrantSettingsAsync(@Nullable Project var1, @NotNull String var2, @NotNull Consumer<RemoteCredentials> var3);

    @NotNull
    public abstract RemoteCredentials getCredentials(@NotNull String var1) throws IOException;

    public static void showMissingVagrantSupportMessage(final @Nullable Project project) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project, (String)"Enable Vagrant Support plugin", (String)"Vagrant Support Disabled");
            }
        });
    }

    public abstract boolean checkVagrantRunning(String var1, boolean var2);

    public abstract void runVagrant(String var1) throws ExecutionException;

    public abstract Collection<? extends RemoteConnector> getVagrantInstancesConnectors(@NotNull Project var1);

    public abstract boolean isVagrantInstance(VirtualFile var1);
}

