/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Condition;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.LinearGraphWithCommitInfo;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import com.intellij.vcs.log.graph.impl.facade.AbstractVisibleGraph;
import com.intellij.vcs.log.graph.impl.print.FilterPrintElementsManager;
import com.intellij.vcs.log.graph.impl.visible.FilterGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.impl.visible.adapters.GraphWithHiddenNodesAsGraphWithCommitInfo;
import com.intellij.vcs.log.graph.impl.visible.adapters.LinearGraphAsGraphWithHiddenNodes;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterVisibleGraph<CommitId>
extends AbstractVisibleGraph<CommitId> {
    @NotNull
    private final FilterGraphWithHiddenNodes myGraphWithHiddenNodes;

    @NotNull
    public static <CommitId> FilterVisibleGraph<CommitId> newInstance(final @NotNull PermanentGraphInfo<CommitId> permanentGraph, @Nullable Set<CommitId> heads, final @NotNull Condition<CommitId> filter) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "newInstance"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "newInstance"));
        }
        LinearGraphAsGraphWithHiddenNodes branchesGraph = FilterVisibleGraph.createBranchesGraph(permanentGraph, heads);
        Condition<Integer> isVisibleNode = new Condition<Integer>(){

            public boolean value(Integer integer) {
                Object commitId = permanentGraph.getPermanentCommitsInfo().getCommitId(integer);
                return filter.value(commitId);
            }
        };
        FilterGraphWithHiddenNodes filterGraphWithHiddenNodes = new FilterGraphWithHiddenNodes(branchesGraph, isVisibleNode);
        GraphWithHiddenNodesAsGraphWithCommitInfo<CommitId> graphWithCommitInfo = new GraphWithHiddenNodesAsGraphWithCommitInfo<CommitId>(filterGraphWithHiddenNodes, permanentGraph.getPermanentGraphLayout(), permanentGraph.getPermanentCommitsInfo());
        FilterPrintElementsManager<CommitId> printElementsManager = new FilterPrintElementsManager<CommitId>(graphWithCommitInfo, permanentGraph.getGraphColorManager());
        FilterVisibleGraph<CommitId> filterVisibleGraph = new FilterVisibleGraph<CommitId>(graphWithCommitInfo, filterGraphWithHiddenNodes, permanentGraph.getCommitsWithNotLoadParent(), printElementsManager);
        if (filterVisibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "newInstance"));
        }
        return filterVisibleGraph;
    }

    private FilterVisibleGraph(@NotNull LinearGraphWithCommitInfo<CommitId> linearGraphWithCommitInfo, @NotNull FilterGraphWithHiddenNodes graphWithHiddenNodes, @NotNull Map<CommitId, GraphCommit<CommitId>> commitsWithNotLoadParent, @NotNull PrintElementsManager printElementsManager) {
        if (linearGraphWithCommitInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraphWithCommitInfo", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "<init>"));
        }
        if (graphWithHiddenNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphWithHiddenNodes", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "<init>"));
        }
        if (commitsWithNotLoadParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsWithNotLoadParent", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "<init>"));
        }
        super(linearGraphWithCommitInfo, commitsWithNotLoadParent, printElementsManager);
        this.myGraphWithHiddenNodes = graphWithHiddenNodes;
    }

    @Override
    protected void setLinearBranchesExpansion(boolean collapse) {
    }

    @Override
    @NotNull
    protected GraphAnswer<CommitId> clickByElement(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "clickByElement"));
        }
        AbstractVisibleGraph.GraphAnswerImpl graphAnswerImpl = this.COMMIT_ID_GRAPH_ANSWER;
        if (graphAnswerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/FilterVisibleGraph", "clickByElement"));
        }
        return graphAnswerImpl;
    }
}

