/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.awt.Component;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
implements VcsLogUi,
Disposable {
    public static final String POPUP_ACTION_GROUP = "Vcs.Log.ContextMenu";
    public static final String TOOLBAR_ACTION_GROUP = "Vcs.Log.Toolbar";
    public static final String VCS_LOG_TABLE_PLACE = "Vcs.Log.ContextMenu";
    private static final Logger LOG = Logger.getInstance(VcsLogUiImpl.class);
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogFilterer myFilterer;
    @NotNull
    private final Collection<VcsLogListener> myLogListeners;
    @NotNull
    private VisiblePack myVisiblePack;

    public VcsLogUiImpl(@NotNull VcsLogDataHolder logDataHolder, @NotNull Project project, @NotNull VcsLogSettings settings, @NotNull VcsLogColorManager manager, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterer filterer) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (filterer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterer", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        this.myLogListeners = ContainerUtil.newArrayList();
        this.myLogDataHolder = logDataHolder;
        this.myProject = project;
        this.myColorManager = manager;
        this.myUiProperties = uiProperties;
        Disposer.register((Disposable)logDataHolder, (Disposable)this);
        this.myFilterer = filterer;
        this.myLog = new VcsLogImpl(logDataHolder, this);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myMainFrame = new MainFrame(logDataHolder, this, project, settings, uiProperties, this.myLog, this.myVisiblePack);
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pack", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setVisiblePack"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TIntHashSet previouslySelected = this.getSelectedCommits();
        PermanentGraph<Integer> previousPermGraph = this.myVisiblePack.getPermanentGraph();
        this.myVisiblePack = pack;
        boolean permGraphChanged = previousPermGraph != this.myVisiblePack.getPermanentGraph();
        GraphTableModel newModel = new GraphTableModel(this.myVisiblePack, this.myLogDataHolder, this);
        this.setModel(newModel, this.myVisiblePack.getVisibleGraph(), previouslySelected);
        this.myMainFrame.updateDataPack(this.myVisiblePack);
        this.setLongEdgeVisibility(this.myUiProperties.areLongEdgesVisible());
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.repaintUI();
    }

    @NotNull
    public MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getMainFrame"));
        }
        return mainFrame;
    }

    public void jumpToRow(final int rowIndex) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().jumpToRow(rowIndex);
            }
        });
    }

    private void setModel(@NotNull GraphTableModel newModel, @NotNull VisibleGraph<Integer> newVisibleGraph, @NotNull TIntHashSet previouslySelectedCommits) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModel", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setModel"));
        }
        if (newVisibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibleGraph", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setModel"));
        }
        if (previouslySelectedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previouslySelectedCommits", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setModel"));
        }
        VcsLogGraphTable table = this.getTable();
        table.setModel(newModel);
        VcsLogUiImpl.restoreSelection(newModel, newVisibleGraph, previouslySelectedCommits, table);
        table.setPaintBusy(false);
    }

    private static void restoreSelection(@NotNull GraphTableModel newModel, @NotNull VisibleGraph<Integer> newVisibleGraph, @NotNull TIntHashSet previouslySelectedCommits, final @NotNull VcsLogGraphTable table) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModel", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        if (newVisibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibleGraph", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        if (previouslySelectedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previouslySelectedCommits", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/VcsLogUiImpl", "restoreSelection"));
        }
        TIntHashSet rowsToSelect = VcsLogUiImpl.findNewRowsToSelect(newModel, newVisibleGraph, previouslySelectedCommits);
        rowsToSelect.forEach(new TIntProcedure(){

            public boolean execute(int row) {
                table.addRowSelectionInterval(row, row);
                return true;
            }
        });
    }

    @NotNull
    private static TIntHashSet findNewRowsToSelect(@NotNull GraphTableModel newModel, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull TIntHashSet selectedHashes) {
        if (newModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModel", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        if (selectedHashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedHashes", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        TIntHashSet rowsToSelect = new TIntHashSet();
        if (newModel.getRowCount() == 0) {
            TIntHashSet tIntHashSet = rowsToSelect;
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
            }
            return tIntHashSet;
        }
        for (int row = 0; row < visibleGraph.getVisibleCommitCount() && rowsToSelect.size() < selectedHashes.size(); ++row) {
            int commit = (Integer)visibleGraph.getRowInfo(row).getCommit();
            if (!selectedHashes.contains(commit)) continue;
            rowsToSelect.add(row);
        }
        TIntHashSet tIntHashSet = rowsToSelect;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "findNewRowsToSelect"));
        }
        return tIntHashSet;
    }

    public void repaintUI() {
        this.myMainFrame.getGraphTable().repaint();
    }

    public void showAll() {
        this.runUnderModalProgress("Expanding linear branches...", new Runnable(){

            @Override
            public void run() {
                VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLinearBranchesExpansion(false);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VcsLogUiImpl.this.handleAnswer(null, true);
                    }
                });
            }
        });
    }

    public void hideAll() {
        this.runUnderModalProgress("Collapsing linear branches...", new Runnable(){

            @Override
            public void run() {
                VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLinearBranchesExpansion(true);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VcsLogUiImpl.this.handleAnswer(null, true);
                    }
                });
            }
        });
    }

    public void setLongEdgeVisibility(boolean visibility) {
        this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(!visibility);
        this.myUiProperties.setLongEdgesVisibility(visibility);
    }

    public void setBek(boolean bek) {
        this.myUiProperties.setBek(bek);
        this.myFilterer.onSortTypeChange(bek ? PermanentGraph.SortType.Bek : PermanentGraph.SortType.Normal);
    }

    public boolean isBek() {
        return this.myUiProperties.isBek();
    }

    public void jumpToCommit(@NotNull Hash commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommit"));
        }
        this.jumpTo(commitHash, new PairFunction<GraphTableModel, Hash, Integer>(){

            public Integer fun(GraphTableModel model, Hash hash) {
                return model.getRowOfCommit(hash);
            }
        });
    }

    public void jumpToCommitByPartOfHash(@NotNull String commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommitByPartOfHash"));
        }
        this.jumpTo(commitHash, new PairFunction<GraphTableModel, String, Integer>(){

            public Integer fun(GraphTableModel model, String hash) {
                return model.getRowOfCommitByPartOfHash(hash);
            }
        });
    }

    public void handleAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange) {
        int row;
        if (dataCouldChange) {
            ((AbstractTableModel)this.getTable().getModel()).fireTableDataChanged();
        }
        this.repaintUI();
        if (answer == null) {
            return;
        }
        if (answer.getCursorToSet() != null) {
            this.myMainFrame.getGraphTable().setCursor(answer.getCursorToSet());
        }
        if (answer.getCommitToJump() != null && (row = this.myVisiblePack.getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump())) >= 0) {
            this.jumpToRow(row);
        }
    }

    private <T> void jumpTo(final @NotNull T commitId, final @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        if (rowGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowGetter", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        GraphTableModel model = this.getModel();
        if (model == null) {
            return;
        }
        int row = (Integer)rowGetter.fun((Object)model, commitId);
        if (row >= 0) {
            this.jumpToRow(row);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(new Runnable(){

                @Override
                public void run() {
                    VcsLogUiImpl.this.jumpTo(commitId, rowGetter);
                }
            });
        } else {
            this.commitNotFound(commitId.toString());
        }
    }

    @Nullable
    private GraphTableModel getModel() {
        TableModel model = this.getTable().getModel();
        if (model instanceof GraphTableModel) {
            return (GraphTableModel)model;
        }
        this.showMessage(MessageType.WARNING, "The log is not ready to search yet");
        return null;
    }

    private void showMessage(@NotNull MessageType messageType, @NotNull String message) {
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/vcs/log/ui/VcsLogUiImpl", "showMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/ui/VcsLogUiImpl", "showMessage"));
        }
        LOG.info(message);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, messageType, new NamedRunnable[0]);
    }

    private void commitNotFound(@NotNull String commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/ui/VcsLogUiImpl", "commitNotFound"));
        }
        if (this.getFilters().isEmpty()) {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " not found");
        } else {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " doesn't exist or doesn't match the active filters");
        }
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getColorManager"));
        }
        return vcsLogColorManager;
    }

    @NotNull
    public TIntHashSet getSelectedCommits() {
        int[] selectedRows = this.getTable().getSelectedRows();
        TIntHashSet tIntHashSet = VcsLogUiImpl.getCommitsAtRows(this.myVisiblePack.getVisibleGraph(), selectedRows);
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getSelectedCommits"));
        }
        return tIntHashSet;
    }

    @NotNull
    private static TIntHashSet getCommitsAtRows(@NotNull VisibleGraph<Integer> graph, int[] rows) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getCommitsAtRows"));
        }
        TIntHashSet commits = new TIntHashSet();
        for (int row : rows) {
            if (row >= graph.getVisibleCommitCount()) continue;
            commits.add(((Integer)graph.getRowInfo(row).getCommit()).intValue());
        }
        TIntHashSet tIntHashSet = commits;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getCommitsAtRows"));
        }
        return tIntHashSet;
    }

    public void applyFiltersAndUpdateUi() {
        this.myFilterer.onFiltersChange(this.getFilters());
    }

    @NotNull
    public VcsLogFilterer getFilterer() {
        VcsLogFilterer vcsLogFilterer = this.myFilterer;
        if (vcsLogFilterer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilterer"));
        }
        return vcsLogFilterer;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myMainFrame.getFilterUi().getFilters();
        if (vcsLogFilterCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilters"));
        }
        return vcsLogFilterCollection;
    }

    public VcsLogGraphTable getTable() {
        return this.myMainFrame.getGraphTable();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getProject"));
        }
        return project;
    }

    public void runUnderModalProgress(final @NotNull String task, final @NotNull Runnable runnable) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/vcs/log/ui/VcsLogUiImpl", "runUnderModalProgress"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/ui/VcsLogUiImpl", "runUnderModalProgress"));
        }
        this.getTable().executeWithoutRepaint(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, task, false, null, VcsLogUiImpl.this.getMainFrame().getMainComponent());
            }
        });
    }

    public void setBranchesPanelVisible(boolean visible) {
        this.myMainFrame.setBranchesPanelVisible(visible);
    }

    public Component getToolbar() {
        return this.myMainFrame.getToolbar();
    }

    @NotNull
    public VcsLog getVcsLog() {
        VcsLog vcsLog = this.myLog;
        if (vcsLog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getVcsLog"));
        }
        return vcsLog;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogFilterUi vcsLogFilterUi = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilterUi"));
        }
        return vcsLogFilterUi;
    }

    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getDataPack"));
        }
        return visiblePack;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/VcsLogUiImpl", "addHighlighter"));
        }
        this.getTable().addHighlighter(highlighter);
        this.repaintUI();
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/VcsLogUiImpl", "removeHighlighter"));
        }
        this.getTable().removeHighlighter(highlighter);
        this.repaintUI();
    }

    public void addLogListener(@NotNull VcsLogListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/ui/VcsLogUiImpl", "addLogListener"));
        }
        this.myLogListeners.add(listener);
    }

    public void removeLogListener(@NotNull VcsLogListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/ui/VcsLogUiImpl", "removeLogListener"));
        }
        this.myLogListeners.remove(listener);
    }

    private void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/VcsLogUiImpl", "fireFilterChangeEvent"));
        }
        for (VcsLogListener listener : this.myLogListeners) {
            listener.onChange((VcsLogDataPack)visiblePack, refresh);
        }
    }

    public void dispose() {
        this.getTable().removeAllHighlighters();
    }
}

