/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneUtils {
    private CloneUtils() {
    }

    public static boolean isCloneable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Cloneable");
    }

    public static boolean isDirectlyCloneable(@NotNull PsiClass aClass) {
        PsiClass[] interfaces;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/CloneUtils", "isDirectlyCloneable"));
        }
        for (PsiClass anInterface : interfaces = aClass.getInterfaces()) {
            String qualifiedName;
            if (anInterface == null || !"java.lang.Cloneable".equals(qualifiedName = anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClone(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType javaLangObject = !PsiUtil.isLanguageLevel5OrHigher((PsiElement)method) ? TypeUtils.getObjectType((PsiElement)method) : null;
        return MethodUtils.methodMatches(method, null, (PsiType)javaLangObject, "clone", PsiType.EMPTY_ARRAY);
    }

    public static boolean onlyThrowsCloneNotSupportedException(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/CloneUtils", "onlyThrowsCloneNotSupportedException"));
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
        PsiExpression exception = throwStatement.getException();
        if (!(exception instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)exception;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return false;
        }
        String qualifiedName = classReference.getQualifiedName();
        return qualifiedName.equals("java.lang.CloneNotSupportedException");
    }
}

