/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.frame.ExecutionStackImpl;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;

public class SuspendContextImpl
extends XSuspendContext {
    private final ExecutionStackImpl executionStack;
    private final SuspendContext suspendContext;

    protected SuspendContextImpl(@NotNull SuspendContext suspendContext, @NotNull DebuggerViewSupport debugProcess, @Nullable Script topFrameScript) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/debugger/frame/SuspendContextImpl", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "org/jetbrains/debugger/frame/SuspendContextImpl", "<init>"));
        }
        this.executionStack = new ExecutionStackImpl(suspendContext, debugProcess, topFrameScript);
        this.suspendContext = suspendContext;
    }

    public void clearObjectCaches() {
        this.suspendContext.getValueManager().clearCaches();
    }

    @NotNull
    public XExecutionStack getActiveExecutionStack() {
        ExecutionStackImpl executionStackImpl = this.executionStack;
        if (executionStackImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl", "getActiveExecutionStack"));
        }
        return executionStackImpl;
    }

    public AsyncResult<String> evaluateExpression(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        CallFrameView frame = this.executionStack.getTopFrame();
        if (frame == null) {
            return new AsyncResult.Rejected((Object)"Top frame is null");
        }
        return SuspendContextImpl.evaluateExpression(frame.getCallFrame().getEvaluateContext(), expression);
    }

    private static String formatErrorMessage(@Nullable String reason) {
        String messagePrefix = "Can not evaluate log expression";
        return reason != null ? messagePrefix + ": " + reason : messagePrefix;
    }

    @NotNull
    private static AsyncResult<String> evaluateExpression(@NotNull EvaluateContext evaluateContext, @NotNull String expression) {
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        final AsyncResult result = new AsyncResult();
        evaluateContext.evaluate(expression).doWhenDone((Consumer)new Consumer<Value>(){

            public void consume(final Value value) {
                if (value == null) {
                    result.setDone((Object)"Log expression result doesn't have value");
                } else if (value instanceof StringValue && ((StringValue)value).isTruncated()) {
                    ((StringValue)value).getFullString().doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            result.setDone((Object)value.getValueString());
                        }
                    }).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            result.setRejected((Object)SuspendContextImpl.formatErrorMessage("whole expression result can not be loaded"));
                        }
                    });
                } else {
                    result.setDone((Object)value.getValueString());
                }
            }
        }).doWhenRejected((PairConsumer)new PairConsumer<Value, String>(){

            public void consume(Value value, String error) {
                if (value == null) {
                    result.setRejected((Object)SuspendContextImpl.formatErrorMessage(error));
                } else {
                    result.setRejected((Object)SuspendContextImpl.formatErrorMessage(value.getValueString()));
                }
            }
        });
        AsyncResult asyncResult = result;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        return asyncResult;
    }
}

