/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IntFieldProperty
extends Property<RadComponent, Integer> {
    private final LabelPropertyRenderer<Integer> myRenderer;
    private final IntEditor myEditor;
    @NotNull
    private final Property myParent;
    private final String myFieldName;
    private final Object myTemplateValue;
    @NonNls
    private static final String METHOD_CLONE = "clone";

    public IntFieldProperty(@NotNull Property parent, @NonNls String fieldName, int lowBoundary, Object templateValue) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/uiDesigner/propertyInspector/properties/IntFieldProperty", "<init>"));
        }
        super(parent, fieldName);
        this.myParent = parent;
        this.myFieldName = fieldName;
        this.myTemplateValue = templateValue;
        this.myRenderer = new LabelPropertyRenderer();
        this.myEditor = new IntEditor(lowBoundary);
    }

    @Override
    public Integer getValue(RadComponent component) {
        Object parentValue = this.myParent.getValue(component);
        if (parentValue == null) {
            return 0;
        }
        try {
            return parentValue.getClass().getField(this.myFieldName).getInt(parentValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void setValueImpl(RadComponent component, Integer value) throws Exception {
        Object parentValue = this.myParent.getValue(component);
        if (parentValue == null) {
            parentValue = this.myTemplateValue;
        } else {
            Method method = parentValue.getClass().getMethod(METHOD_CLONE, ArrayUtil.EMPTY_CLASS_ARRAY);
            parentValue = method.invoke(parentValue, new Object[0]);
        }
        parentValue.getClass().getField(this.myFieldName).setInt(parentValue, value);
        this.myParent.setValue(component, parentValue);
    }

    @Override
    @NotNull
    public PropertyRenderer<Integer> getRenderer() {
        LabelPropertyRenderer<Integer> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntFieldProperty", "getRenderer"));
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<Integer> getEditor() {
        return this.myEditor;
    }
}

