/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeInputFilter
implements InputFilter {
    private static final Logger LOG = Logger.getInstance(CompositeInputFilter.class);
    private final List<Pair<InputFilter, Boolean>> myFilters;
    private final DumbService myDumbService;

    public CompositeInputFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/CompositeInputFilter", "<init>"));
        }
        this.myFilters = ContainerUtilRt.newArrayList();
        this.myDumbService = DumbService.getInstance(project);
    }

    @Override
    @Nullable
    public List<Pair<String, ConsoleViewContentType>> applyFilter(String text, ConsoleViewContentType contentType) {
        boolean dumb = this.myDumbService.isDumb();
        for (Pair<InputFilter, Boolean> pair : this.myFilters) {
            if (dumb && pair.second != Boolean.TRUE) continue;
            long t0 = System.currentTimeMillis();
            InputFilter filter = (InputFilter)pair.first;
            List<Pair<String, ConsoleViewContentType>> result = filter.applyFilter(text, contentType);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 100L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + text + "'''");
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void addFilter(@NotNull InputFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/execution/filters/CompositeInputFilter", "addFilter"));
        }
        this.myFilters.add((Pair<InputFilter, Boolean>)Pair.create((Object)filter, (Object)DumbService.isDumbAware(filter)));
    }
}

