/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntryTemplate;

public class VariableDefinitionEntry
extends AbstractNode {
    private AbstractNode name = this.adopt(new Identifier());
    private int arrayDimensions = 0;
    private AbstractNode initializer = null;

    public VariableDefinition upToVariableDefinition() {
        if (!(this.getParent() instanceof VariableDefinition)) {
            return null;
        }
        VariableDefinition out = (VariableDefinition)this.getParent();
        if (!out.rawVariables().contains(this)) {
            return null;
        }
        return out;
    }

    public Identifier astName() {
        if (!(this.name instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.name;
    }

    public VariableDefinitionEntry astName(Identifier name) {
        return this.rawName(name);
    }

    private VariableDefinitionEntry rawName(Node name) {
        if (name == this.name) {
            return this;
        }
        if (name != null) {
            this.adopt((AbstractNode)name);
        }
        if (this.name != null) {
            this.disown(this.name);
        }
        this.name = (AbstractNode)name;
        return this;
    }

    public int astArrayDimensions() {
        return this.arrayDimensions;
    }

    public VariableDefinitionEntry astArrayDimensions(int arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
        return this;
    }

    public Expression astInitializer() {
        if (!(this.initializer instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.initializer);
    }

    public VariableDefinitionEntry astInitializer(Expression initializer) {
        return this.rawInitializer(initializer);
    }

    public Node rawInitializer() {
        return this.initializer;
    }

    public VariableDefinitionEntry rawInitializer(Node initializer) {
        if (initializer == this.initializer) {
            return this;
        }
        if (initializer != null) {
            this.adopt((AbstractNode)initializer);
        }
        if (this.initializer != null) {
            this.disown(this.initializer);
        }
        this.initializer = (AbstractNode)initializer;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.name != null) {
            result.add(this.name);
        }
        if (this.initializer != null) {
            result.add(this.initializer);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.name == original) {
            if (replacement instanceof Identifier) {
                this.astName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.initializer == original) {
            this.rawInitializer(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.name == child) {
            this.disown((AbstractNode)child);
            this.name = null;
            return true;
        }
        if (this.initializer == child) {
            this.disown((AbstractNode)child);
            this.initializer = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitVariableDefinitionEntry(this)) {
            return;
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.initializer != null) {
            this.initializer.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public VariableDefinitionEntry copy() {
        VariableDefinitionEntry result = new VariableDefinitionEntry();
        if (this.name != null) {
            result.rawName(this.name.copy());
        }
        result.arrayDimensions = this.arrayDimensions;
        if (this.initializer != null) {
            result.rawInitializer(this.initializer.copy());
        }
        return result;
    }

    public TypeReference getEffectiveTypeReference() {
        return VariableDefinitionEntryTemplate.getEffectiveTypeReference(this);
    }

    public Modifiers getModifiersOfParent() {
        return VariableDefinitionEntryTemplate.getModifiersOfParent(this);
    }

    public TypeDeclaration upUpIfFieldToTypeDeclaration() {
        return VariableDefinitionEntryTemplate.upUpIfFieldToTypeDeclaration(this);
    }

    public Block upUpIfLocalVariableToBlock() {
        return VariableDefinitionEntryTemplate.upUpIfLocalVariableToBlock(this);
    }
}

