/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.editors.navigation.Utilities;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nullable;

public class AndroidShowNavigationEditor
extends AnAction {
    public AndroidShowNavigationEditor() {
        super("Navigation Editor", null, AndroidIcons.NavigationEditor);
    }

    public void showNavigationEditor(@Nullable Project project, String dir, String file) {
        if (project == null) {
            return;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return;
        }
        VirtualFile navFile = Utilities.getNavigationFile(baseDir, dir, file);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, navFile, 0);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        manager.openEditor(descriptor, true);
        manager.setSelectedEditor(navFile, "navigationeditor");
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        this.showNavigationEditor(project, "raw", "main.nvg.xml");
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty());
    }
}

