/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.FirstRunWizardStep;
import com.android.tools.idea.welcome.TwoRadiosToBooleanBinding;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkLocationStep
extends FirstRunWizardStep {
    private final ScopedStateStore.Key<Boolean> myShouldDownload;
    private final ScopedStateStore.Key<String> myExistingSdkLocation;
    private JRadioButton myDownloadTheLatestVersionRadioButton;
    private JRadioButton myUseAnExistingAndroidRadioButton;
    private JLabel myError;
    private TextFieldWithBrowseButton myExistingSdkPath;
    private JPanel myContentsPane;

    public SdkLocationStep(ScopedStateStore.Key<Boolean> shouldDownload, ScopedStateStore.Key<String> existingSdkLocation) {
        super("SDK Settings");
        this.myShouldDownload = shouldDownload;
        this.myExistingSdkLocation = existingSdkLocation;
        this.$$$setupUI$$$();
        this.myError.setText("");
        this.myError.setForeground((Color)JBColor.red);
        this.myExistingSdkPath.addBrowseFolderListener("Android SDK", "Provide Android SDK location", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.setComponent(this.myContentsPane);
    }

    @Override
    public boolean validate() {
        this.setErrorHtml(null);
        return this.isDownloading() || this.validateSdkLocation(this.myState.get(this.myExistingSdkLocation));
    }

    private boolean validateSdkLocation(@Nullable String location) {
        String error = null;
        if (StringUtil.isEmpty((String)location)) {
            error = "SDK location is required";
        } else {
            File sdkLocation = new File(location);
            if (!sdkLocation.isDirectory()) {
                error = "Directory does not exist";
            } else {
                Pair<Boolean, String> result = AndroidSdkType.validateAndroidSdk(location);
                if (!((Boolean)result.first).booleanValue()) {
                    error = (String)result.second;
                }
            }
        }
        this.setErrorHtml(error);
        return error == null;
    }

    @Override
    public void init() {
        this.register(this.myExistingSdkLocation, this.myExistingSdkPath);
        this.register(this.myShouldDownload, this.myContentsPane, new TwoRadiosToBooleanBinding(this.myDownloadTheLatestVersionRadioButton, this.myUseAnExistingAndroidRadioButton));
        this.deriveValues((Set<ScopedStateStore.Key>)ImmutableSet.of(this.myShouldDownload));
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        if (modified.contains(this.myShouldDownload)) {
            this.myExistingSdkPath.setEnabled(!this.isDownloading());
        }
    }

    private boolean isDownloading() {
        return Objects.equal((Object)this.myState.get(this.myShouldDownload), (Object)Boolean.TRUE);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDownloadTheLatestVersionRadioButton;
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/SdkLocationStep", "getMessageLabel"));
        }
        return jLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myContentsPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Android Studio requires the Android Software Development Kit (SDK).");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 1, null, new Dimension(-1, 24), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("We could not detect an Android SDK. Select an option:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadTheLatestVersionRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Download the latest version of the Android SDK");
        jPanel.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseAnExistingAndroidRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use an existing Android SDK");
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExistingSdkPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 0, 1, 1, 0, 1, 6, 0, null, null, null, 4));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myError = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentsPane;
    }
}

