/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.intellij.android.designer.designSurface.RootView;
import com.intellij.android.designer.model.IdManager;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayout;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.designer.model.MetaManager;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadComponentOperations {
    private RadComponentOperations() {
    }

    public static RadViewComponent createComponent(@Nullable XmlTag tag, MetaModel metaModel) throws Exception {
        RadViewComponent component = (RadViewComponent)((Object)metaModel.getModel().newInstance());
        component.setMetaModel(metaModel);
        component.setTag(tag);
        Class layout = metaModel.getLayout();
        if (layout == null) {
            component.setLayout(RadViewLayout.INSTANCE);
        } else {
            component.setLayout((RadLayout)layout.newInstance());
        }
        return component;
    }

    public static void moveComponent(final RadViewComponent container, final RadViewComponent movedComponent, final @Nullable RadViewComponent insertBefore) throws Exception {
        PropertyParser propertyParser;
        movedComponent.removeFromParent();
        container.add((RadComponent)movedComponent, (RadComponent)insertBefore);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag xmlTag = movedComponent.getTag();
                XmlTag parentTag = container.getTag();
                XmlTag nextTag = insertBefore == null ? null : insertBefore.getTag();
                XmlTag newXmlTag = nextTag == null ? parentTag.addSubTag(xmlTag, false) : (XmlTag)parentTag.addBefore((PsiElement)xmlTag, (PsiElement)nextTag);
                xmlTag.delete();
                movedComponent.updateTag(newXmlTag);
            }
        });
        XmlFile xmlFile = RadModelBuilder.getXmlFile((RadComponent)container);
        assert (xmlFile != null);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)xmlFile.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)xmlFile);
        if (document != null) {
            psiDocumentManager.commitDocument(document);
        }
        if ((propertyParser = RadModelBuilder.getPropertyParser((RadComponent)container)) != null) {
            propertyParser.load(movedComponent);
        }
    }

    public static void addComponent(RadViewComponent container, final RadViewComponent newComponent, @Nullable RadViewComponent insertBefore) throws Exception {
        IdManager idManager;
        container.add((RadComponent)newComponent, (RadComponent)insertBefore);
        RadComponentOperations.addComponentTag(container.getTag(), newComponent, insertBefore == null ? null : insertBefore.getTag(), new Computable<String>(){

            public String compute() {
                String creation = newComponent.getInitialPaletteItem() != null ? newComponent.getInitialPaletteItem().getCreation() : newComponent.getMetaModel().getCreation();
                return creation == null ? newComponent.getCreationXml() : creation;
            }
        });
        PropertyParser propertyParser = RadModelBuilder.getPropertyParser((RadComponent)container);
        if (propertyParser != null) {
            propertyParser.load(newComponent);
            if (!newComponent.getTag().isEmpty()) {
                RadComponentOperations.addComponent(newComponent, ViewsMetaManager.getInstance(newComponent.getTag().getProject()), propertyParser);
            }
        }
        if ((idManager = IdManager.get((RadComponent)container)) != null && idManager.needsDefaultId(newComponent)) {
            idManager.ensureIds(newComponent);
        }
    }

    private static void addComponent(RadViewComponent parentComponent, MetaManager metaManager, PropertyParser propertyParser) throws Exception {
        for (XmlTag tag : parentComponent.getTag().getSubTags()) {
            MetaModel metaModel = metaManager.getModelByTag(tag.getName());
            if (metaModel == null) {
                metaModel = metaManager.getModelByTag("view");
                assert (metaModel != null);
            }
            RadViewComponent component = RadComponentOperations.createComponent(tag, metaModel);
            parentComponent.add((RadComponent)component, null);
            propertyParser.load(component);
            RadComponentOperations.addComponent(component, metaManager, propertyParser);
        }
    }

    public static void pasteComponent(RadViewComponent container, RadViewComponent newComponent, @Nullable RadViewComponent insertBefore) throws Exception {
        container.add((RadComponent)newComponent, (RadComponent)insertBefore);
        PropertyParser propertyParser = RadModelBuilder.getPropertyParser((RadComponent)container);
        if (propertyParser != null) {
            RadComponentOperations.pasteComponent(newComponent, container.getTag(), insertBefore == null ? null : insertBefore.getTag(), propertyParser);
            IdManager idManager = IdManager.get((RadComponent)container);
            if (idManager != null) {
                idManager.ensureIds(newComponent);
            }
        }
    }

    private static void pasteComponent(final RadViewComponent component, XmlTag parentTag, @Nullable XmlTag nextTag, PropertyParser propertyParser) throws Exception {
        RadComponentOperations.addComponentTag(parentTag, component, nextTag, new Computable<String>(){

            public String compute() {
                Element pasteProperties = (Element)component.extractClientProperty("PASTE_DATA");
                if (pasteProperties == null) {
                    return component.getMetaModel().getCreation();
                }
                StringBuilder builder = new StringBuilder();
                builder.append("<").append(component.getMetaModel().getTag());
                Iterator i$ = pasteProperties.getAttributes().iterator();
                while (i$.hasNext()) {
                    Attribute object;
                    Attribute attribute = object = (Attribute)i$.next();
                    builder.append(" ").append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\"");
                }
                for (Attribute object : pasteProperties.getChildren()) {
                    Element element = (Element)object;
                    String namespace = element.getName();
                    Iterator i$2 = element.getAttributes().iterator();
                    while (i$2.hasNext()) {
                        Attribute child;
                        Attribute attribute = child = (Attribute)i$2.next();
                        builder.append(" ").append(namespace).append(":").append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\"");
                    }
                }
                if (builder.indexOf("android:layout_width=\"") == -1) {
                    builder.append(" android:layout_width=\"wrap_content\"");
                }
                if (builder.indexOf("android:layout_height=\"") == -1) {
                    builder.append(" android:layout_height=\"wrap_content\"");
                }
                return builder.append("/>").toString();
            }
        });
        XmlTag xmlTag = component.getTag();
        List<RadComponent> children = component.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            RadViewComponent child = (RadViewComponent)children.get(i);
            XmlTag nextChildTag = null;
            if (i + 1 < size) {
                nextChildTag = ((RadViewComponent)children.get(i + 1)).getTag();
            }
            RadComponentOperations.pasteComponent(child, xmlTag, nextChildTag, propertyParser);
        }
        propertyParser.load(component);
    }

    public static void addComponentTag(final XmlTag parentTag, final RadViewComponent component, final @Nullable XmlTag nextTag, final Computable<String> tagBuilder) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Project project;
                RadViewComponent root = null;
                XmlFile xmlFile = null;
                if (!RadComponentOperations.checkTag(parentTag) && component.getParent() == component.getRoot()) {
                    root = (RadViewComponent)component.getParent();
                    xmlFile = RadModelBuilder.getXmlFile((RadComponent)root);
                    assert (xmlFile != null);
                    project = xmlFile.getProject();
                } else {
                    project = parentTag.getProject();
                }
                Language language = StdFileTypes.XML.getLanguage();
                XmlTag xmlTag = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("\n" + (String)tagBuilder.compute()), language);
                if (RadComponentOperations.checkTag(parentTag)) {
                    String namespacePrefix = parentTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                    if (namespacePrefix != null && !"android".equals(namespacePrefix)) {
                        RadComponentOperations.convertNamespacePrefix(xmlTag, namespacePrefix);
                    }
                    xmlTag = nextTag == null ? parentTag.addSubTag(xmlTag, false) : (XmlTag)parentTag.addBefore((PsiElement)xmlTag, (PsiElement)nextTag);
                } else {
                    XmlDocument document;
                    xmlTag.setAttribute("xmlns:android", "http://schemas.android.com/apk/res/android");
                    if (xmlFile != null && (document = xmlFile.getDocument()) != null) {
                        xmlTag = (XmlTag)document.add((PsiElement)xmlTag);
                        XmlUtil.expandTag((XmlTag)xmlTag);
                        XmlTag rootTag = document.getRootTag();
                        if (rootTag != null) {
                            root.setTag(rootTag);
                        }
                    }
                }
                component.setTag(xmlTag);
            }
        });
    }

    private static boolean checkTag(XmlTag tag) {
        try {
            return tag != null && tag.getFirstChild() != null && !(tag.getFirstChild() instanceof PsiErrorElement);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static void convertNamespacePrefix(XmlTag xmlTag, String namespacePrefix) {
        for (XmlAttribute xmlAttribute : xmlTag.getAttributes()) {
            if (!"android".equals(xmlAttribute.getNamespacePrefix())) continue;
            xmlAttribute.setName(namespacePrefix + ":" + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : xmlTag.getSubTags()) {
            RadComponentOperations.convertNamespacePrefix((XmlTag)xmlAttribute, namespacePrefix);
        }
    }

    public static void deleteAttribute(RadComponent component, String name) {
        RadComponentOperations.deleteAttribute(((RadViewComponent)component).getTag(), name);
    }

    public static void deleteAttribute(XmlTag tag, String name) {
        RadComponentOperations.deleteAttribute(tag, name, "http://schemas.android.com/apk/res/android");
    }

    public static void deleteAttribute(XmlTag tag, String name, String namespace) {
        XmlAttribute attribute = tag.getAttribute(name, namespace);
        if (attribute != null) {
            attribute.delete();
        }
    }

    @Nullable
    public RadViewComponent updateRootComponent(@NotNull RenderResult result, @Nullable RadViewComponent prevRoot, @NotNull RootView nativeComponent) throws Exception {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/android/designer/model/RadComponentOperations", "updateRootComponent"));
        }
        if (nativeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeComponent", "com/intellij/android/designer/model/RadComponentOperations", "updateRootComponent"));
        }
        assert (false);
        return null;
    }

    public static void printTree(StringBuilder builder, RadComponent component, int level) {
        for (int i = 0; i < level; ++i) {
            builder.append('\t');
        }
        builder.append(component).append(" | ").append(component.getLayout()).append(" | ").append(component.getMetaModel().getTag()).append(" | ").append(component.getMetaModel().getTarget()).append(" = ").append(component.getChildren().size()).append("\n");
        for (RadComponent childComponent : component.getChildren()) {
            RadComponentOperations.printTree(builder, childComponent, level + 1);
        }
    }

    public static void printTree(StringBuilder builder, ViewInfo viewInfo, int level) {
        for (int i = 0; i < level; ++i) {
            builder.append('\t');
        }
        builder.append(viewInfo.getClassName()).append(" | ");
        try {
            builder.append(viewInfo.getViewObject()).append(" | ");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            builder.append(viewInfo.getLayoutParamsObject()).append(" = ");
        }
        catch (Throwable e) {
            // empty catch block
        }
        builder.append(viewInfo.getChildren().size()).append("\n");
        for (ViewInfo childViewInfo : viewInfo.getChildren()) {
            RadComponentOperations.printTree(builder, childViewInfo, level + 1);
        }
    }
}

