/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubCreatePullRequestDialog
extends DialogWrapper {
    @NotNull
    private final GithubCreatePullRequestPanel myPanel;
    @NotNull
    private final GithubCreatePullRequestWorker myWorker;
    @NotNull
    private final GithubProjectSettings myProjectSettings;
    @NotNull
    private static final CreateRemoteDoNotAskOption ourDoNotAskOption = new CreateRemoteDoNotAskOption();

    public GithubCreatePullRequestDialog(final @NotNull Project project, @NotNull GithubCreatePullRequestWorker worker) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "<init>"));
        }
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "<init>"));
        }
        super(project, true);
        this.myWorker = worker;
        this.myProjectSettings = GithubProjectSettings.getInstance(project);
        this.myPanel = new GithubCreatePullRequestPanel();
        this.myPanel.getShowDiffButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GithubCreatePullRequestDialog.this.myWorker.showDiffDialog(GithubCreatePullRequestDialog.this.myPanel.getSelectedBranch());
            }
        });
        this.myPanel.getSelectForkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GithubCreatePullRequestWorker.ForkInfo fork = GithubCreatePullRequestDialog.this.myWorker.showTargetDialog();
                if (fork != null) {
                    GithubCreatePullRequestDialog.this.myPanel.setForks(GithubCreatePullRequestDialog.this.myWorker.getForks());
                    GithubCreatePullRequestDialog.this.myPanel.setSelectedFork(fork.getPath());
                }
            }
        });
        this.myPanel.getForkComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    GithubCreatePullRequestDialog.this.myPanel.setBranches(Collections.<GithubCreatePullRequestWorker.BranchInfo>emptyList());
                }
                if (e.getStateChange() == 1) {
                    GithubCreatePullRequestWorker.ForkInfo fork = (GithubCreatePullRequestWorker.ForkInfo)e.getItem();
                    if (fork == null) {
                        return;
                    }
                    GithubCreatePullRequestDialog.this.myPanel.setBranches(fork.getBranches());
                    GithubCreatePullRequestDialog.this.myPanel.setSelectedBranch(fork.getDefaultBranch());
                    if (fork.getRemoteName() == null && !fork.isProposedToCreateRemote()) {
                        fork.setProposedToCreateRemote(true);
                        boolean createRemote = false;
                        switch (GithubSettings.getInstance().getCreatePullRequestCreateRemote()) {
                            case YES: {
                                createRemote = true;
                                break;
                            }
                            case NO: {
                                createRemote = false;
                                break;
                            }
                            case UNSURE: {
                                createRemote = GithubNotifications.showYesNoDialog(project, "Can't Find Remote", "Configure remote for '" + fork.getPath().getUser() + "'?", ourDoNotAskOption);
                            }
                        }
                        if (createRemote) {
                            GithubCreatePullRequestDialog.this.myWorker.configureRemote(fork);
                        }
                    }
                    if (fork.getRemoteName() == null) {
                        GithubCreatePullRequestDialog.this.myPanel.setDiffEnabled(false);
                    } else {
                        GithubCreatePullRequestDialog.this.myPanel.setDiffEnabled(true);
                        GithubCreatePullRequestDialog.this.myWorker.launchFetchRemote(fork);
                    }
                }
            }
        });
        this.myPanel.getBranchComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GithubCreatePullRequestWorker.BranchInfo branch = (GithubCreatePullRequestWorker.BranchInfo)e.getItem();
                    if (branch == null) {
                        return;
                    }
                    if (branch.getForkInfo().getRemoteName() != null) {
                        if (branch.getDiffInfoTask() != null && branch.getDiffInfoTask().isDone() && branch.getDiffInfoTask().safeGet() == null) {
                            GithubCreatePullRequestDialog.this.myPanel.setDiffEnabled(false);
                        } else {
                            GithubCreatePullRequestDialog.this.myPanel.setDiffEnabled(true);
                        }
                    }
                    if (GithubCreatePullRequestDialog.this.myPanel.isTitleDescriptionEmptyOrNotModified()) {
                        Couple<String> description = GithubCreatePullRequestDialog.this.myWorker.getDefaultDescriptionMessage(branch);
                        GithubCreatePullRequestDialog.this.myPanel.setTitle((String)description.getFirst());
                        GithubCreatePullRequestDialog.this.myPanel.setDescription((String)description.getSecond());
                    }
                    GithubCreatePullRequestDialog.this.myWorker.launchLoadDiffInfo(branch);
                }
            }
        });
        this.myPanel.setForks(this.myWorker.getForks());
        this.myPanel.setSelectedFork(this.myProjectSettings.getCreatePullRequestDefaultRepo());
        this.myPanel.setSelectedBranch(this.myProjectSettings.getCreatePullRequestDefaultBranch());
        this.setTitle("Create Pull Request - " + this.myWorker.getCurrentBranch());
        this.init();
    }

    protected void doOKAction() {
        GithubCreatePullRequestWorker.BranchInfo branch = this.myPanel.getSelectedBranch();
        if (this.myWorker.checkAction(branch)) {
            assert (branch != null);
            this.myWorker.createPullRequest(branch, this.getRequestTitle(), this.getDescription());
            this.myProjectSettings.setCreatePullRequestDefaultBranch(branch.getRemoteName());
            this.myProjectSettings.setCreatePullRequestDefaultRepo(branch.getForkInfo().getPath());
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredComponent();
    }

    protected String getHelpId() {
        return "github.create.pull.request.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreatePullRequestDialog";
    }

    @NotNull
    private String getRequestTitle() {
        String string = this.myPanel.getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "getRequestTitle"));
        }
        return string;
    }

    @NotNull
    private String getDescription() {
        String string = this.myPanel.getDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "getDescription"));
        }
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmptyOrSpaces((String)this.getRequestTitle())) {
            return new ValidationInfo("Title can't be empty'", this.myPanel.getTitleTextField());
        }
        return null;
    }

    public void testSetRequestTitle(String title) {
        this.myPanel.setTitle(title);
    }

    public void testSetBranch(String branch) {
        this.myPanel.setSelectedBranch(branch);
    }

    public void testCreatePullRequest() {
        this.myWorker.createPullRequest(this.myPanel.getSelectedBranch(), this.getRequestTitle(), this.getDescription());
    }

    public void testSetFork(@NotNull GithubFullPath forkPath) {
        if (forkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forkPath", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "testSetFork"));
        }
        this.myPanel.setSelectedFork(forkPath);
    }

    private static class CreateRemoteDoNotAskOption
    implements DialogWrapper.DoNotAskOption {
        private CreateRemoteDoNotAskOption() {
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean value, int exitCode) {
            if (value) {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.UNSURE);
            } else if (exitCode == 0) {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.YES);
            } else {
                GithubSettings.getInstance().setCreatePullRequestCreateRemote(ThreeState.NO);
            }
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog$CreateRemoteDoNotAskOption", "getDoNotShowMessage"));
            }
            return string;
        }
    }
}

