/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

class MapBinding
implements Binding {
    private static final Logger LOG = Logger.getInstance(MapBinding.class);
    private static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
    };
    private final Binding myKeyBinding;
    private final Binding myValueBinding;
    private final MapAnnotation myMapAnnotation;

    public MapBinding(ParameterizedType type, Accessor accessor) {
        Type[] arguments = type.getActualTypeArguments();
        Type keyType = arguments[0];
        Type valueType = arguments[1];
        this.myKeyBinding = XmlSerializerImpl.getBinding(keyType);
        this.myValueBinding = XmlSerializerImpl.getBinding(valueType);
        this.myMapAnnotation = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), MapAnnotation.class);
    }

    @Override
    @Nullable
    public Object serialize(Object o, @Nullable Object context, SerializationFilter filter) {
        Element m;
        Map map = (Map)o;
        Element element = m = this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag() ? new Element("map") : (Element)context;
        assert (m != null);
        Object[] keys = ArrayUtil.toObjectArray(map.keySet());
        if (this.myMapAnnotation == null || this.myMapAnnotation.sortBeforeSave()) {
            Arrays.sort(keys, KEY_COMPARATOR);
        }
        for (Object k : keys) {
            Object v = map.get(k);
            Element entry = new Element(this.getEntryAttributeName());
            m.addContent(entry);
            Object kNode = this.myKeyBinding.serialize(k, entry, filter);
            if (kNode instanceof Text) {
                entry.setAttribute(this.getKeyAttributeName(), ((Text)kNode).getText());
            } else if (kNode != null) {
                if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
                    entry.addContent((Content)kNode);
                } else {
                    Element key = new Element(this.getKeyAttributeName());
                    entry.addContent(key);
                    key.addContent((Content)kNode);
                }
            }
            Object vNode = this.myValueBinding.serialize(v, entry, filter);
            if (vNode instanceof Text) {
                entry.setAttribute(this.getValueAttributeName(), ((Text)vNode).getText());
                continue;
            }
            if (vNode == null) continue;
            if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundValueWithTag()) {
                entry.addContent((Element)vNode);
                continue;
            }
            Element value = new Element(this.getValueAttributeName());
            entry.addContent(value);
            value.addContent((Content)vNode);
        }
        return m == context ? null : m;
    }

    private String getEntryAttributeName() {
        return this.myMapAnnotation == null ? "entry" : this.myMapAnnotation.entryTagName();
    }

    private String getKeyAttributeName() {
        return this.myMapAnnotation == null ? "key" : this.myMapAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        return this.myMapAnnotation == null ? "value" : this.myMapAnnotation.valueAttributeName();
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        Object[] childNodes;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/MapBinding", "deserialize"));
        }
        Map map = (Map)o;
        map.clear();
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            assert (nodes.length == 1);
            Element m = (Element)nodes[0];
            childNodes = JDOMUtil.getContent(m);
        } else {
            childNodes = nodes;
        }
        for (Object childNode : childNodes) {
            if (XmlSerializerImpl.isIgnoredNode(childNode)) continue;
            Element entry = (Element)childNode;
            Object k = null;
            Object v = null;
            if (!entry.getName().equals(this.getEntryAttributeName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + entry);
                continue;
            }
            Attribute keyAttr = entry.getAttribute(this.getKeyAttributeName());
            if (keyAttr != null) {
                k = this.myKeyBinding.deserialize(o, keyAttr);
            } else if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
                for (Content child : JDOMUtil.getContent(entry)) {
                    if (!this.myKeyBinding.isBoundTo(child)) continue;
                    k = this.myKeyBinding.deserialize(o, child);
                    break;
                }
            } else {
                Object keyNode = entry.getChildren(this.getKeyAttributeName()).get(0);
                k = this.myKeyBinding.deserialize(o, JDOMUtil.getContent((Element)keyNode));
            }
            Attribute valueAttr = entry.getAttribute(this.getValueAttributeName());
            if (valueAttr != null) {
                v = this.myValueBinding.deserialize(o, valueAttr);
            } else if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundValueWithTag()) {
                for (Content child : JDOMUtil.getContent(entry)) {
                    if (!this.myValueBinding.isBoundTo(child)) continue;
                    v = this.myValueBinding.deserialize(o, child);
                    break;
                }
            } else {
                Object valueNode = entry.getChildren(this.getValueAttributeName()).get(0);
                v = this.myValueBinding.deserialize(o, XmlSerializerImpl.getNotIgnoredContent((Element)valueNode));
            }
            map.put(k, v);
        }
        return map;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundWithTag()) {
            return this.myMapAnnotation.entryTagName().equals(((Element)node).getName());
        }
        return ((Element)node).getName().equals("map");
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    @Override
    public void init() {
    }
}

