/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.provider.update.HgHeadMerger;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCommonBranchActions
extends ActionGroup {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected String myBranchName;
    @NotNull
    List<HgRepository> myRepositories;

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "<init>"));
        }
        super("", true);
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRepositories = repositories;
        this.getTemplatePresentation().setText(this.myBranchName, false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new UpdateAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName)};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgCommonBranchActions", "getChildren"));
        }
        return anActionArray;
    }

    private static class UpdateAction
    extends HgBranchAbstractAction {
        public UpdateAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            super(project, "Update", repositories, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            for (HgRepository repo : this.myRepositories) {
                final VirtualFile repository = repo.getRoot();
                final HgUpdateCommand hgUpdateCommand = new HgUpdateCommand(this.myProject, repository);
                hgUpdateCommand.setBranch(this.myBranchName);
                new Task.Backgroundable(this.myProject, HgVcsMessages.message("action.hg4idea.updateTo.description", this.myBranchName)){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction$1", "run"));
                        }
                        HgCommandResult result = hgUpdateCommand.execute();
                        assert (this.myProject != null);
                        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                            new HgCommandResultNotifier(this.myProject).notifyError(result, "", "Update failed");
                            new HgConflictResolver(this.myProject).resolve(repository);
                        }
                        ((HgUpdater)this.myProject.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.myProject, repository);
                    }
                }.queue();
            }
        }
    }

    private static class MergeAction
    extends HgBranchAbstractAction {
        public MergeAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction", "<init>"));
            }
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction", "<init>"));
            }
            super(project, "Merge", repositories, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            final UpdatedFiles updatedFiles = UpdatedFiles.create();
            for (final HgRepository repository : this.myRepositories) {
                final HgMergeCommand hgMergeCommand = new HgMergeCommand(this.myProject, repository.getRoot());
                hgMergeCommand.setRevision(this.myBranchName);
                new Task.Backgroundable(this.myProject, "Merging changes..."){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction$1", "run"));
                        }
                        try {
                            new HgHeadMerger(this.myProject, hgMergeCommand).merge(repository.getRoot());
                            new HgConflictResolver(this.myProject, updatedFiles).resolve(repository.getRoot());
                        }
                        catch (VcsException exception) {
                            assert (this.myProject != null);
                            if (exception.isWarning()) {
                                VcsNotifier.getInstance((Project)this.myProject).notifyWarning("Warning during merge", exception.getMessage());
                            } else {
                                VcsNotifier.getInstance((Project)this.myProject).notifyError("Exception during merge", exception.getMessage());
                            }
                        }
                        catch (Exception e1) {
                            HgAbstractGlobalAction.handleException(this.myProject, e1);
                        }
                    }
                }.queue();
            }
        }
    }
}

