/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyChannel;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.emulator.JediEmulator;
import javax.swing.SwingUtilities;

public class JBTerminalStarter
extends TerminalStarter {
    public JBTerminalStarter(Terminal terminal, TtyConnector ttyConnector) {
        super(terminal, ttyConnector);
    }

    protected JediEmulator createEmulator(TtyChannel channel, TerminalOutputStream stream, Terminal terminal) {
        return new JediEmulator((TerminalDataStream)channel, stream, terminal){

            protected void unsupported(char ... sequenceChars) {
                if (sequenceChars[0] == '\u0007') {
                    JBTerminalStarter.refreshAfterExecution();
                } else {
                    super.unsupported(new char[0]);
                }
            }
        };
    }

    public static void refreshAfterExecution() {
        if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            LocalFileSystem.getInstance().refresh(false);
                        }
                    });
                }
            });
        }
    }
}

