/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrNumberConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return false;
    }

    @Override
    @Nullable
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrNumberConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrNumberConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrNumberConverter", "isConvertible"));
        }
        if (TypesUtil.isNumericType(lType) && TypesUtil.isNumericType(rType)) {
            return Boolean.TRUE;
        }
        return null;
    }
}

