/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public abstract class AbstractTestEvent
implements TestEvent {
    private final GradleTestsExecutionConsoleManager myConsoleManager;

    public AbstractTestEvent(GradleTestsExecutionConsoleManager consoleManager) {
        this.myConsoleManager = consoleManager;
    }

    public GradleTestsExecutionConsoleManager getConsoleManager() {
        return this.myConsoleManager;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.myConsoleManager.getExecutionConsole().getResultsViewer();
    }

    protected Project getProject() {
        return this.myConsoleManager.getExecutionConsole().getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getConsoleManager().getExecutionConsole().getProperties();
    }

    @Nullable
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        if (fqClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqClassName", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "findLocationUrl"));
        }
        return name == null ? "gradle://className::" + fqClassName : "gradle://methodName::" + fqClassName + '.' + name;
    }

    protected String getTestName(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        if (eventXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "getTestName"));
        }
        return eventXml.queryXml("/ijLog/event/test/descriptor/@name");
    }

    protected String getParentTestId(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        if (eventXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "getParentTestId"));
        }
        return eventXml.queryXml("/ijLog/event/test/@parentId");
    }

    protected String getTestId(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        if (eventXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "getTestId"));
        }
        return eventXml.queryXml("/ijLog/event/test/@id");
    }

    protected String getTestClassName(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        if (eventXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "getTestClassName"));
        }
        return eventXml.queryXml("/ijLog/event/test/descriptor/@className");
    }

    protected TestEventResult getTestEventResultType(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        if (eventXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEvent", "getTestEventResultType"));
        }
        return TestEventResult.fromValue(eventXml.queryXml("/ijLog/event/test/result/@resultType"));
    }

    protected void addToInvokeLater(Runnable runnable) {
        ExternalSystemApiUtil.addToInvokeLater((Runnable)runnable);
    }
}

