/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAllAffectedGenericAction
extends AnAction
implements DumbAware {
    private static final String ACTION_ID = "VcsHistory.ShowAllAffected";

    private ShowAllAffectedGenericAction() {
    }

    public static ShowAllAffectedGenericAction getInstance() {
        return (ShowAllAffectedGenericAction)ActionManager.getInstance().getAction(ACTION_ID);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsKey vcsKey = e.getData(VcsDataKeys.VCS);
        if (vcsKey == null) {
            return;
        }
        VcsFileRevision revision = e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        Boolean isNonLocal = e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        if (revision != null && revisionVirtualFile != null) {
            ShowAllAffectedGenericAction.showSubmittedFiles(project, revision.getRevisionNumber(), revisionVirtualFile, vcsKey, revision.getChangedRepositoryPath(), Boolean.TRUE.equals(isNonLocal));
        }
    }

    public static void showSubmittedFiles(Project project, VcsRevisionNumber revision, VirtualFile virtualFile, VcsKey vcsKey) {
        ShowAllAffectedGenericAction.showSubmittedFiles(project, revision, virtualFile, vcsKey, null, false);
    }

    public static void showSubmittedFiles(final Project project, final VcsRevisionNumber revision, final VirtualFile virtualFile, VcsKey vcsKey, final RepositoryLocation location, final boolean isNonLocal) {
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance(project).findVcsByName(vcsKey.getName());
        if (vcs == null) {
            return;
        }
        if (isNonLocal && !ShowAllAffectedGenericAction.canPresentNonLocal(project, vcsKey, virtualFile)) {
            return;
        }
        final String title = VcsBundle.message("paths.affected.in.revision", revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString());
        final CommittedChangeList[] list = new CommittedChangeList[1];
        final VcsException[] exc = new VcsException[1];
        Task.Backgroundable task = new Task.Backgroundable(project, title, true, BackgroundFromStartOption.getInstance()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/annotate/ShowAllAffectedGenericAction$1", "run"));
                }
                try {
                    CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                    if (!isNonLocal) {
                        Pair pair = provider.getOneList(virtualFile, revision);
                        if (pair != null) {
                            list[0] = (CommittedChangeList)pair.getFirst();
                        }
                    } else {
                        if (location != null) {
                            Object settings = provider.createDefaultSettings();
                            ((ChangeBrowserSettings)settings).USE_CHANGE_BEFORE_FILTER = true;
                            ((ChangeBrowserSettings)settings).CHANGE_BEFORE = revision.asString();
                            List changes = provider.getCommittedChanges(settings, location, 1);
                            if (changes != null && changes.size() == 1) {
                                list[0] = (CommittedChangeList)changes.get(0);
                            }
                            return;
                        }
                        list[0] = ShowAllAffectedGenericAction.getRemoteList(vcs, revision, virtualFile);
                    }
                }
                catch (VcsException e) {
                    exc[0] = e;
                }
            }

            @Override
            public void onSuccess() {
                AbstractVcsHelper instance = AbstractVcsHelper.getInstance(project);
                if (exc[0] != null) {
                    instance.showError(exc[0], ShowAllAffectedGenericAction.failedText(virtualFile, revision));
                } else if (list[0] == null) {
                    Messages.showErrorDialog(project, ShowAllAffectedGenericAction.failedText(virtualFile, revision), this.getTitle());
                } else {
                    instance.showChangesListBrowser(list[0], virtualFile, title);
                }
            }
        };
        ProgressManager.getInstance().run(task);
    }

    public static CommittedChangeList getRemoteList(AbstractVcs vcs, VcsRevisionNumber revision, VirtualFile nonLocal) throws VcsException {
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        RepositoryLocation local = provider.getForNonLocal(nonLocal);
        if (local != null) {
            String number = revision.asString();
            Object settings = provider.createDefaultSettings();
            List changes = provider.getCommittedChanges(settings, local, provider.getUnlimitedCountValue());
            if (changes != null) {
                for (CommittedChangeList change : changes) {
                    if (!number.equals(String.valueOf(change.getNumber()))) continue;
                    return change;
                }
            }
        }
        return null;
    }

    private static String failedText(VirtualFile virtualFile, VcsRevisionNumber revision) {
        return "Show all affected files for " + virtualFile.getPath() + " at " + revision.asString() + " failed";
    }

    @Override
    public void update(AnActionEvent e) {
        Project project = e.getData(CommonDataKeys.PROJECT);
        VcsKey vcsKey = e.getData(VcsDataKeys.VCS);
        if (project == null || vcsKey == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Boolean isNonLocal = e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        VirtualFile revisionVirtualFile = e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        boolean enabled = e.getData(VcsDataKeys.VCS_FILE_REVISION) != null && revisionVirtualFile != null;
        enabled = enabled && (!Boolean.TRUE.equals(isNonLocal) || ShowAllAffectedGenericAction.canPresentNonLocal(project, vcsKey, revisionVirtualFile));
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean canPresentNonLocal(Project project, VcsKey key, VirtualFile file) {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance(project).findVcsByName(key.getName());
        if (vcs == null) {
            return false;
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return false;
        }
        return provider.getForNonLocal(file) != null;
    }
}

