/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;
import org.jetbrains.annotations.NotNull;

public abstract class IndexPatternSearch
extends QueryFactory<IndexPatternOccurrence, SearchParameters> {
    public static IndexPatternSearch INDEX_PATTERN_SEARCH_INSTANCE = ServiceManager.getService(IndexPatternSearch.class);

    protected IndexPatternSearch() {
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, pattern);
        Query<IndexPatternOccurrence> query = INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, pattern, new TextRange(startOffset, endOffset));
        Query<IndexPatternOccurrence> query = INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        Query<IndexPatternOccurrence> query = INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider, new TextRange(startOffset, endOffset));
        Query<IndexPatternOccurrence> query = INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/IndexPatternSearch", "search"));
        }
        return query;
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/search/searches/IndexPatternSearch", "getOccurrencesCount"));
        }
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPattern var2);

    public static class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this(file, pattern, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern, TextRange range) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this.myFile = file;
            this.myRange = range;
            this.myPatternProvider = null;
            this.myPattern = pattern;
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (patternProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this(file, patternProvider, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            if (patternProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "<init>"));
            }
            this.myFile = file;
            this.myPatternProvider = patternProvider;
            this.myRange = range;
            this.myPattern = null;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters", "getFile"));
            }
            return psiFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }
    }
}

