/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.ui.AbstractDomElementComponent;
import com.intellij.util.xml.ui.BasicDomElementComponent;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.DomUINavigationProvider;
import com.intellij.util.xml.ui.Highlightable;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileEditor<T extends BasicDomElementComponent>
extends PerspectiveFileEditor
implements CommittablePanel,
Highlightable {
    private final String myName;
    private final Factory<? extends T> myComponentFactory;
    private T myComponent;

    public DomFileEditor(DomElement element, String name, T component) {
        this(element.getManager().getProject(), DomUtil.getFile(element).getVirtualFile(), name, component);
    }

    public DomFileEditor(Project project, VirtualFile file, String name, T component) {
        this(project, file, name, new Factory<T>((BasicDomElementComponent)component){
            final /* synthetic */ BasicDomElementComponent val$component;
            {
                this.val$component = basicDomElementComponent;
            }

            public T create() {
                return this.val$component;
            }
        });
    }

    public DomFileEditor(Project project, VirtualFile file, String name, Factory<? extends T> component) {
        super(project, file);
        this.myComponentFactory = component;
        this.myName = name;
        DomElementAnnotationsManager.getInstance(project).addHighlightingListener(new DomElementAnnotationsManager.DomHighlightingListener(){

            @Override
            public void highlightingFinished(@NotNull DomFileElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/ui/DomFileEditor$2", "highlightingFinished"));
                }
                if (DomFileEditor.this.isInitialised() && DomFileEditor.this.getComponent().isShowing() && element.isValid()) {
                    DomFileEditor.this.updateHighlighting();
                }
            }
        }, this);
    }

    @Override
    public void updateHighlighting() {
        if (this.checkIsValid()) {
            CommittableUtil.updateHighlighting(this.myComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.checkIsValid() && this.isInitialised()) {
            this.setShowing(false);
            try {
                ServiceManager.getService(this.getProject(), CommittableUtil.class).commit((Committable)this.myComponent);
            }
            finally {
                this.setShowing(true);
            }
        }
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        this.ensureInitialized();
        return this.myComponent.getComponent();
    }

    protected final T getDomComponent() {
        return this.myComponent;
    }

    @Override
    @NotNull
    protected JComponent createCustomComponent() {
        new MnemonicHelper().register(this.getComponent());
        this.myComponent = (BasicDomElementComponent)this.myComponentFactory.create();
        DomUIFactory.getDomUIFactory().setupErrorOutdatingUserActivityWatcher(this, this.getDomElement());
        DomManager.getDomManager(this.getProject()).addDomEventListener(new DomEventListener(){

            @Override
            public void eventOccured(DomEvent event) {
                DomFileEditor.this.checkIsValid();
            }
        }, this);
        Disposer.register((Disposable)this, this.myComponent);
        JComponent jComponent = this.myComponent.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomFileEditor", "createCustomComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/DomFileEditor", "getName"));
        }
        return string;
    }

    @Override
    protected DomElement getSelectedDomElement() {
        if (this.myComponent == null) {
            return null;
        }
        return DomUINavigationProvider.findDomElement(this.myComponent);
    }

    @Override
    protected void setSelectedDomElement(DomElement domElement) {
        DomUIControl domControl = DomUINavigationProvider.findDomControl(this.myComponent, domElement);
        if (domControl != null) {
            domControl.navigate(domElement);
        }
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        this.ensureInitialized();
        return DomUIFactory.getDomUIFactory().createDomHighlighter(this.getProject(), this, this.getDomElement());
    }

    private DomElement getDomElement() {
        return ((AbstractDomElementComponent)this.myComponent).getDomElement();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (!this.isInitialised() || this.getDomElement().isValid());
    }

    @Override
    public void reset() {
        if (this.checkIsValid()) {
            ((CompositeCommittable)this.myComponent).reset();
        }
    }

    public static DomFileEditor createDomFileEditor(final String name, final @Nullable Icon icon, final DomElement element, final Factory<? extends CommittablePanel> committablePanel) {
        XmlFile file = DomUtil.getFile(element);
        Factory<BasicDomElementComponent> factory = new Factory<BasicDomElementComponent>(){

            public BasicDomElementComponent create() {
                CaptionComponent captionComponent = new CaptionComponent(name, icon);
                captionComponent.initErrorPanel(element);
                BasicDomElementComponent component = DomFileEditor.createComponentWithCaption((CommittablePanel)committablePanel.create(), captionComponent, element);
                Disposer.register((Disposable)component, (Disposable)captionComponent);
                return component;
            }
        };
        return new DomFileEditor<BasicDomElementComponent>(file.getProject(), file.getVirtualFile(), name, (Factory)factory){

            @Override
            public JComponent getPreferredFocusedComponent() {
                return null;
            }
        };
    }

    public static BasicDomElementComponent createComponentWithCaption(CommittablePanel committablePanel, CaptionComponent captionComponent, DomElement element) {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)captionComponent, "North");
        panel.add((Component)(element.isValid() ? committablePanel.getComponent() : new JPanel()), "Center");
        BasicDomElementComponent component = new BasicDomElementComponent(element){

            @Override
            public JComponent getComponent() {
                return panel;
            }
        };
        component.addComponent(committablePanel);
        component.addComponent(captionComponent);
        return component;
    }
}

