/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogProvider {
    @NotNull
    public DetailedLogData readFirstBlock(@NotNull VirtualFile var1, @NotNull Requirements var2) throws VcsException;

    @NotNull
    public LogData readAllHashes(@NotNull VirtualFile var1, @NotNull Consumer<TimedVcsCommit> var2) throws VcsException;

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile var1, @NotNull List<String> var2) throws VcsException;

    @NotNull
    public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile var1, @NotNull List<String> var2) throws VcsException;

    @NotNull
    public VcsKey getSupportedVcs();

    @NotNull
    public VcsLogRefManager getReferenceManager();

    public void subscribeToRootRefreshEvents(@NotNull Collection<VirtualFile> var1, @NotNull VcsLogRefresher var2);

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile var1, @NotNull VcsLogFilterCollection var2, int var3) throws VcsException;

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile var1) throws VcsException;

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile var1, @NotNull Hash var2) throws VcsException;

    public static interface DetailedLogData {
        @NotNull
        public List<VcsCommitMetadata> getCommits();

        @NotNull
        public Set<VcsRef> getRefs();
    }

    public static interface LogData {
        @NotNull
        public Set<VcsRef> getRefs();

        @NotNull
        public Set<VcsUser> getUsers();
    }

    public static interface Requirements {
        public int getCommitCount();
    }
}

