/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdConfigurationOptionHelpPanel
extends JPanel {
    private static final String NO_OPTION_SELECTED = "Nothing Selected";
    private static final int PADDING = 20;
    private String myErrorMessage;
    private String myTitle;
    private String myDescriptionBody;
    private static Map<ScopedStateStore.Key<?>, String> TITLES = ImmutableMap.builder().put(AvdWizardConstants.RAM_STORAGE_KEY, (Object)"Device RAM").put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, (Object)"Virtual Machine Heap").put(AvdWizardConstants.INTERNAL_STORAGE_KEY, (Object)"Internal Flash").put(AvdWizardConstants.SD_CARD_STORAGE_KEY, (Object)"New SD Card Size").put(AvdWizardConstants.EXISTING_SD_LOCATION, (Object)"Location of SD card image").put(AvdWizardConstants.SCALE_SELECTION_KEY, (Object)"Start-Up Size").put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, (Object)"Default Orientation").put(AvdWizardConstants.NETWORK_SPEED_KEY, (Object)"Network Speed").put(AvdWizardConstants.NETWORK_LATENCY_KEY, (Object)"Network Latency").put(AvdWizardConstants.FRONT_CAMERA_KEY, (Object)"Front Camera").put(AvdWizardConstants.BACK_CAMERA_KEY, (Object)"Back Camera").put(AvdWizardConstants.USE_HOST_GPU_KEY, (Object)"Use Host GPU").put(AvdWizardConstants.USE_SNAPSHOT_KEY, (Object)"Enable Snapshot").put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, (Object)"Custom Hardware Skin").build();
    private static Map<ScopedStateStore.Key<?>, String> DESCRIPTIONS = ImmutableMap.builder().put(AvdWizardConstants.RAM_STORAGE_KEY, (Object)"The amount of physical RAM on the device.\n1 MB = 1024 KB\n1 GB = 1025 MB").put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, (Object)"The amount of RAM available to Java virtual machine (VM) to allocate to running apps on the device. A larger VM heap allows application to run longer between garbage collection event.").put(AvdWizardConstants.INTERNAL_STORAGE_KEY, (Object)"The amount of non-removable space available to store data on the device.").put(AvdWizardConstants.SD_CARD_STORAGE_KEY, (Object)"The amount of removable space available to store data on the device. ").put(AvdWizardConstants.EXISTING_SD_LOCATION, (Object)"Choose a file path to an existing SD Card image. Using an external SD Card is useful when sharing SD Card data (pictures, media, files, etc.) between Android Virtual Devices. ").put(AvdWizardConstants.SCALE_SELECTION_KEY, (Object)"Enables you to test your application on a screen that uses a resolution or density not supported by the built-in AVD skins, you can create an AVD that uses a custom resolution by selecting one of the scale values.").put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, (Object)"Sets the initial orientation of the device. During AVD emulation you can also rotate the device screen. ").put(AvdWizardConstants.NETWORK_SPEED_KEY, (Object)"Sets the initial state of the simulated network transfer rate used by AVD.  The network speed can also be adjusted in the emulator.").put(AvdWizardConstants.NETWORK_LATENCY_KEY, (Object)"Sets the initial state of the simulated network transfer latency used by AVD.  Latency is the delay in processing data across the network. The latency speed can also be adjusted in the emulator.").put(AvdWizardConstants.FRONT_CAMERA_KEY, (Object)"None - no camera installed for AVD\nEmulated - use a simulated camera\nDevice -  use host computer webcam or built-in camera").put(AvdWizardConstants.BACK_CAMERA_KEY, (Object)"None - no camera installed for AVD\nEmulated - use a simulated camera\nDevice -  use host computer webcam or built-in camera").put(AvdWizardConstants.USE_HOST_GPU_KEY, (Object)"This enables the emulator graphics to run faster by using your computer's graphics card for OpenGL ES graphics rendering.  (Recommended for better emulator experience)").put(AvdWizardConstants.USE_SNAPSHOT_KEY, (Object)"Helps improve emulator re-start performance.  Start the AVD from the AVD manager and check Launch from snapshot and Save to snapshot. This way, when you close the emulator, a snapshot of the AVD state is saved and used to quickly re-launch the AVD next time.  Note this will make the emulator slow to close. ").put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, (Object)"A collection of images and configuration data that indicates how to populate the window. Each skin can have several \"layouts\" (e.g. \"landscape\" and \"portrait\") corresponding to different orientation / physical configurations of the emulated device.\n").build();

    public void setDescriptionText(@Nullable String descriptionText) {
        if (descriptionText == null || descriptionText.isEmpty()) {
            this.myTitle = null;
            this.myDescriptionBody = null;
            return;
        }
        Iterable iterable = Splitter.on((char)'|').split((CharSequence)descriptionText);
        this.myTitle = (String)Iterables.getFirst((Iterable)iterable, null);
        this.myDescriptionBody = (String)Iterables.getLast((Iterable)iterable, null);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(JBColor.foreground());
        g2d.setFont(AvdWizardConstants.STANDARD_FONT);
        if (this.myTitle == null) {
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.drawString(NO_OPTION_SELECTED, (this.getWidth() - metrics.stringWidth(NO_OPTION_SELECTED)) / 2, (this.getHeight() - metrics.getHeight()) / 2);
            return;
        }
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        FontMetrics metrics = g.getFontMetrics(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myTitle, 20, 20 + metrics.getHeight() / 2);
        g2d.drawLine(0, 50, this.getWidth(), 50);
        int stringHeight = g2d.getFontMetrics(AvdWizardConstants.TITLE_FONT).getHeight();
        int infoSegmentX = 20;
        int infoSegmentY = 20 + stringHeight * 2;
        g2d.setFont(AvdWizardConstants.STANDARD_FONT);
        int maxWidth = this.getWidth() - 40;
        if (this.myErrorMessage != null) {
            g2d.setColor((Color)JBColor.RED);
            infoSegmentY += AvdConfigurationOptionHelpPanel.drawMultilineString(g2d, this.myErrorMessage, maxWidth, infoSegmentX, infoSegmentY);
        }
        infoSegmentY += stringHeight;
        if (this.myDescriptionBody != null) {
            g2d.setColor(JBColor.foreground());
            for (String line : Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\n\r")).omitEmptyStrings().split((CharSequence)this.myDescriptionBody)) {
                infoSegmentY += AvdConfigurationOptionHelpPanel.drawMultilineString(g2d, line, maxWidth, infoSegmentX, infoSegmentY);
            }
        }
    }

    private static int drawMultilineString(@NotNull Graphics2D g2d, @NotNull String fullString, int maxWidth, int startX, int startY) {
        if (g2d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/avdmanager/AvdConfigurationOptionHelpPanel", "drawMultilineString"));
        }
        if (fullString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullString", "com/android/tools/idea/avdmanager/AvdConfigurationOptionHelpPanel", "drawMultilineString"));
        }
        int currentY = startY;
        FontMetrics metrics = g2d.getFontMetrics();
        int stringHeight = metrics.getHeight();
        Iterable parts = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)fullString);
        String currentLine = "";
        for (String part : parts) {
            if (metrics.stringWidth(currentLine + part) > maxWidth) {
                g2d.drawString(currentLine, startX, currentY += stringHeight);
                currentLine = "";
            }
            currentLine = currentLine + part + " ";
        }
        if (!currentLine.isEmpty()) {
            g2d.drawString(currentLine, startX, currentY += stringHeight);
        }
        return currentY - startY;
    }

    public void setErrorMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/avdmanager/AvdConfigurationOptionHelpPanel", "setErrorMessage"));
        }
        this.myErrorMessage = message;
        this.repaint();
    }

    public String getDescription(ScopedStateStore.Key<?> key) {
        return TITLES.get(key) + "|" + DESCRIPTIONS.get(key);
    }
}

