/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG);
    private static DeviceManager ourDeviceManager;
    private static Map<File, SkinLayoutDefinition> ourSkinLayoutDefinitions;

    private static boolean initIfNecessary() {
        if (ourDeviceManager == null) {
            AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData == null) {
                IJ_LOG.error("No installed SDK found!");
                return false;
            }
            LocalSdk localSdk = androidSdkData.getLocalSdk();
            ourDeviceManager = DeviceManager.createInstance((File)localSdk.getLocation(), (ILogger)SDK_LOG);
        }
        return true;
    }

    @NotNull
    public static List<Device> getDevices() {
        if (!DeviceManagerConnection.initIfNecessary()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "getDevices"));
            }
            return immutableList;
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)ourDeviceManager.getDevices(DeviceManager.ALL_DEVICES));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "getDevices"));
        }
        return arrayList;
    }

    @NotNull
    public static String getUniqueId(@Nullable String id) {
        String baseId;
        String string = baseId = id == null ? "New Device" : id;
        if (!DeviceManagerConnection.initIfNecessary()) {
            String string2 = baseId;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "getUniqueId"));
            }
            return string2;
        }
        Collection devices = ourDeviceManager.getDevices(DeviceManager.DeviceFilter.USER);
        String candidate = baseId;
        int i = 0;
        while (DeviceManagerConnection.anyIdMatches(candidate, devices)) {
            candidate = String.format(Locale.getDefault(), "%s %d", baseId, ++i);
        }
        String string3 = candidate;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "getUniqueId"));
        }
        return string3;
    }

    private static boolean anyIdMatches(@NotNull String id, @NotNull Collection<Device> devices) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "anyIdMatches"));
        }
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "anyIdMatches"));
        }
        for (Device d : devices) {
            if (!id.equalsIgnoreCase(d.getId())) continue;
            return true;
        }
        return false;
    }

    public static void deleteDevice(@Nullable Device info) {
        if (info != null) {
            if (!DeviceManagerConnection.initIfNecessary()) {
                return;
            }
            ourDeviceManager.removeUserDevice(info);
        }
    }

    public static void createOrEditDevice(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "createOrEditDevice"));
        }
        if (!DeviceManagerConnection.initIfNecessary()) {
            return;
        }
        ourDeviceManager.replaceUserDevice(device);
        ourDeviceManager.saveUserDevices();
    }

    public static boolean isUserDevice(final @NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceManagerConnection", "isUserDevice"));
        }
        if (!DeviceManagerConnection.initIfNecessary()) {
            return false;
        }
        return Iterables.any((Iterable)ourDeviceManager.getDevices(DeviceManager.DeviceFilter.USER), (Predicate)new Predicate<Device>(){

            public boolean apply(Device input) {
                return device.getId().equalsIgnoreCase(input.getId());
            }
        });
    }

    static {
        ourSkinLayoutDefinitions = Maps.newHashMap();
    }
}

