/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    private static final Logger LOG = Logger.getInstance(ProjectSetUpTask.class);
    @NotNull
    private final Project myProject;
    private final boolean myProjectIsNew;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, boolean projectIsNew, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "<init>"));
        }
        this.myProject = project;
        this.myProjectIsNew = projectIsNew;
        this.mySyncListener = syncListener;
    }

    public void onSuccess(final @Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        final Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectSetUpTask.this.populateProject((DataNode<ProjectData>)projectInfo);
                boolean isTest = application.isUnitTestMode();
                if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                    if (ProjectSetUpTask.this.myProjectIsNew) {
                        Projects.open(ProjectSetUpTask.this.myProject);
                    }
                    if (!isTest) {
                        ProjectSetUpTask.this.myProject.save();
                    }
                }
                if (!ProjectSetUpTask.this.isAndroidProject((DataNode<ProjectData>)projectInfo)) {
                    PostProjectSetupTasksExecutor.getInstance(ProjectSetUpTask.this.myProject).onProjectSyncCompletion();
                }
                if (ProjectSetUpTask.this.myProjectIsNew) {
                    AndroidGradleProjectComponent projectComponent = (AndroidGradleProjectComponent)((Object)ServiceManager.getService((Project)ProjectSetUpTask.this.myProject, AndroidGradleProjectComponent.class));
                    projectComponent.configureGradleProject(false);
                }
                if (ProjectSetUpTask.this.mySyncListener != null) {
                    ProjectSetUpTask.this.mySyncListener.syncSucceeded(ProjectSetUpTask.this.myProject);
                }
            }
        };
        if (application.isUnitTestMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    private void populateProject(final @NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "populateProject"));
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)ProjectSetUpTask.this.myProject){

                    public void execute() {
                        ProjectRootManagerEx.getInstanceEx((Project)ProjectSetUpTask.this.myProject).mergeRootsChangesDuring(new Runnable(){

                            @Override
                            public void run() {
                                ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                                Collection modules = ExternalSystemApiUtil.findAll((DataNode)projectInfo, (Key)ProjectKeys.MODULE);
                                dataManager.importData(ProjectKeys.MODULE, modules, ProjectSetUpTask.this.myProject, true);
                            }
                        });
                    }
                });
            }
        });
    }

    public boolean isAndroidProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "isAndroidProject"));
        }
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        for (DataNode moduleInfo : modules) {
            Collection androidProjects = ExternalSystemApiUtil.findAll((DataNode)moduleInfo, AndroidProjectKeys.IDE_ANDROID_PROJECT);
            if (androidProjects.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "onFailure"));
        }
        if (errorDetails != null) {
            LOG.warn(errorDetails);
        }
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        LOG.info(newMessage);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }
}

