/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.AndroidCommonBundle;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.exportSignedPackage.ApkStep;
import org.jetbrains.android.exportSignedPackage.ChooseModuleStep;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GradleSignStep;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class ExportSignedPackageWizard
extends AbstractWizard<ExportSignedPackageWizardStep> {
    private static final Logger LOG = Logger.getInstance(ExportSignedPackageWizard.class);
    private static final String NOTIFICATION_TITLE = "Generate signed APK";
    private static final String NOTIFICATION_GROUPID = "Android";
    private final Project myProject;
    private AndroidFacet myFacet;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private boolean mySigned;
    private CompileScope myCompileScope;
    private String myApkPath;
    private String myBuildType;
    private List<String> myFlavors;
    private GradleSigningInfo myGradleSigningInfo;

    public ExportSignedPackageWizard(Project project, List<AndroidFacet> facets, boolean signed) {
        super(AndroidBundle.message("android.export.package.wizard.title", new Object[0]), project);
        this.myProject = project;
        this.mySigned = signed;
        assert (facets.size() > 0);
        if (facets.size() > 1 || SystemInfo.isMac) {
            this.addStep((Step)new ChooseModuleStep(this, facets));
        } else {
            this.myFacet = facets.get(0);
        }
        boolean useGradleToSign = facets.get(0).isGradleProject();
        if (signed) {
            this.addStep((Step)new KeystoreStep(this, useGradleToSign));
        }
        if (useGradleToSign) {
            this.addStep((Step)new GradleSignStep(this));
        } else {
            this.addStep((Step)new ApkStep(this));
        }
        this.init();
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    protected void doOKAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doOKAction();
        assert (this.myFacet != null);
        if (this.myFacet.isGradleProject()) {
            this.buildAndSignGradleProject();
        } else {
            this.buildAndSignIntellijProject();
        }
    }

    private void buildAndSignIntellijProject() {
        CompilerManager.getInstance((Project)this.myProject).make(this.myCompileScope, new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || errors != 0) {
                    return;
                }
                String title = AndroidBundle.message("android.extract.package.task.title", new Object[0]);
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(ExportSignedPackageWizard.this.myProject, title, true, null){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$1$1", "run"));
                        }
                        ExportSignedPackageWizard.this.createAndAlignApk(ExportSignedPackageWizard.this.myApkPath);
                    }
                });
            }
        });
    }

    private void buildAndSignGradleProject() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Generating signed APKs", false, null){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$2", "run"));
                }
                AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(ExportSignedPackageWizard.this.myFacet.getModule());
                if (gradleFacet == null) {
                    LOG.error("Unable to get gradle project information for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                String gradleProjectPath = ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                IdeaAndroidProject ideaAndroidProject = ExportSignedPackageWizard.this.myFacet.getIdeaAndroidProject();
                if (ideaAndroidProject == null) {
                    LOG.error("Unable to obtain gradle project model. Did the last Gradle sync complete successfully?");
                    return;
                }
                List<String> assembleTasks = ExportSignedPackageWizard.getAssembleTasks(gradleProjectPath, ideaAndroidProject.getDelegate(), ExportSignedPackageWizard.this.myBuildType, ExportSignedPackageWizard.this.myFlavors);
                ArrayList projectProperties = Lists.newArrayList();
                projectProperties.add(this.createProperty("android.injected.signing.store.file", ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStoreFilePath));
                projectProperties.add(this.createProperty("android.injected.signing.store.password", new String(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStorePassword)));
                projectProperties.add(this.createProperty("android.injected.signing.key.alias", ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyAlias));
                projectProperties.add(this.createProperty("android.injected.signing.key.password", new String(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyPassword)));
                projectProperties.add(this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
                final GradleInvoker gradleInvoker = GradleInvoker.getInstance(this.myProject);
                GradleInvoker.AfterGradleInvocationTask afterTask = new GradleInvoker.AfterGradleInvocationTask(){

                    @Override
                    public void execute(@NotNull GradleInvocationResult result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$2$1", "execute"));
                        }
                        if (result.isBuildSuccessful()) {
                            if (ShowFilePathAction.isSupported()) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Messages.showOkCancelDialog((Project)myProject, (String)"Signed APK's generated successfully.", (String)ExportSignedPackageWizard.NOTIFICATION_TITLE, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
                                            ShowFilePathAction.openDirectory((File)new File(ExportSignedPackageWizard.this.myApkPath));
                                        }
                                    }
                                });
                            } else {
                                Notifications.Bus.notify((Notification)new Notification(ExportSignedPackageWizard.NOTIFICATION_GROUPID, ExportSignedPackageWizard.NOTIFICATION_TITLE, "Signed APK's are in: " + ExportSignedPackageWizard.this.myApkPath, NotificationType.INFORMATION));
                            }
                        } else {
                            Notifications.Bus.notify((Notification)new Notification(ExportSignedPackageWizard.NOTIFICATION_GROUPID, ExportSignedPackageWizard.NOTIFICATION_TITLE, "Errors while building apk, see messages tool window for list of errors.", NotificationType.ERROR));
                        }
                        gradleInvoker.removeAfterGradleInvocationTask(this);
                    }
                };
                gradleInvoker.addAfterGradleInvocationTask(afterTask);
                gradleInvoker.executeTasks(assembleTasks, projectProperties);
            }

            private String createProperty(@NotNull String name, @NotNull String value) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$2", "createProperty"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$2", "createProperty"));
                }
                return AndroidGradleSettings.createProjectProperty((String)name, (String)value);
            }
        });
    }

    public static List<String> getAssembleTasks(String gradleProjectPath, AndroidProject androidProject, String buildType, List<String> flavors) {
        HashMap variantsByFlavor = Maps.newHashMapWithExpectedSize((int)flavors.size());
        for (Variant v : androidProject.getVariants()) {
            if (!v.getBuildType().equals(buildType)) continue;
            variantsByFlavor.put(ExportSignedPackageWizard.getMergedFlavorName(v), v);
        }
        if (flavors.isEmpty()) {
            Variant v = (Variant)variantsByFlavor.get("");
            if (v != null) {
                String taskName = v.getMainArtifact().getAssembleTaskName();
                return Collections.singletonList(GradleInvoker.createBuildTask(gradleProjectPath, taskName));
            }
            LOG.error("Unable to find default variant");
            return Collections.emptyList();
        }
        ArrayList assembleTasks = Lists.newArrayListWithExpectedSize((int)flavors.size());
        for (String flavor : flavors) {
            Variant v = (Variant)variantsByFlavor.get(flavor);
            if (v == null) continue;
            String taskName = v.getMainArtifact().getAssembleTaskName();
            assembleTasks.add(GradleInvoker.createBuildTask(gradleProjectPath, taskName));
        }
        return assembleTasks;
    }

    public static String getMergedFlavorName(Variant variant) {
        return Joiner.on((char)'-').join((Iterable)variant.getProductFlavors());
    }

    protected void doNextAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doNextAction();
    }

    private boolean commitCurrentStep() {
        try {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(this.myCurrentStep))).commitForNext();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected int getNextStep(int stepIndex) {
        int result = super.getNextStep(stepIndex);
        if (result != this.myCurrentStep) {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(result))).setPreviousStepIndex(this.myCurrentStep);
        }
        return result;
    }

    protected int getPreviousStep(int stepIndex) {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(stepIndex));
        int prevStepIndex = step.getPreviousStepIndex();
        assert (prevStepIndex >= 0);
        return prevStepIndex;
    }

    protected void updateStep() {
        int step = this.getCurrentStep();
        final ExportSignedPackageWizardStep currentStep = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(step));
        this.getFinishButton().setEnabled(currentStep.canFinish());
        super.updateStep();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportSignedPackageWizard.this.getRootPane().setDefaultButton(ExportSignedPackageWizard.this.getNextButton());
                final JComponent component = currentStep.getPreferredFocusedComponent();
                if (component != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            component.requestFocus();
                        }
                    });
                }
            }
        });
    }

    protected String getHelpID() {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)this.getCurrentStepObject();
        if (step != null) {
            return step.getHelpId();
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard", "setFacet"));
        }
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public void setPrivateKey(@NotNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateKey", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard", "setPrivateKey"));
        }
        this.myPrivateKey = privateKey;
    }

    public void setCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard", "setCertificate"));
        }
        this.myCertificate = certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public void setCompileScope(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard", "setCompileScope"));
        }
        this.myCompileScope = compileScope;
    }

    public void setApkPath(@NotNull String apkPath) {
        if (apkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkPath", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard", "setApkPath"));
        }
        this.myApkPath = apkPath;
    }

    public void setGradleOptions(String buildType, List<String> flavors) {
        this.myBuildType = buildType;
        this.myFlavors = flavors;
    }

    private void createAndAlignApk(final String apkPath) {
        File realDestFile;
        String message;
        BuildToolInfo buildTool;
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform();
        assert (platform != null);
        String sdkPath = platform.getSdkData().getPath();
        String zipAlignPath = AndroidCommonUtils.getZipAlign((String)sdkPath, (IAndroidTarget)platform.getTarget());
        File zipalign = new File(zipAlignPath);
        if (!zipalign.isFile() && (buildTool = platform.getTarget().getBuildToolInfo()) != null) {
            zipAlignPath = buildTool.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
            zipalign = new File(zipAlignPath);
        }
        final boolean runZipAlign = zipalign.isFile();
        File destFile = null;
        try {
            destFile = runZipAlign ? FileUtil.createTempFile((String)"android", (String)".apk") : new File(apkPath);
            this.createApk(destFile);
        }
        catch (Exception e) {
            this.showErrorInDispatchThread(e.getMessage());
        }
        if (destFile == null) {
            return;
        }
        if (runZipAlign && (message = AndroidCommonUtils.executeZipAlign((String)zipAlignPath, (File)destFile, (File)(realDestFile = new File(apkPath)))) != null) {
            this.showErrorInDispatchThread(message);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = AndroidBundle.message("android.export.package.wizard.title", new Object[0]);
                Project project = ExportSignedPackageWizard.this.getProject();
                File apkFile = new File(apkPath);
                VirtualFile vApkFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(apkFile);
                if (vApkFile != null) {
                    vApkFile.refresh(true, false);
                }
                if (!runZipAlign) {
                    Messages.showWarningDialog((Project)project, (String)AndroidCommonBundle.message((String)"android.artifact.building.cannot.find.zip.align.error", (Object[])new Object[0]), (String)title);
                }
                if (ShowFilePathAction.isSupported()) {
                    if (Messages.showOkCancelDialog((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile.getName()), (String)title, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
                        ShowFilePathAction.openFile((File)apkFile);
                    }
                } else {
                    Messages.showInfoMessage((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile), (String)title);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    private void createApk(File destFile) throws IOException, GeneralSecurityException {
        String srcApkPath = AndroidCompileUtil.getUnsignedApkPath(this.getFacet());
        File srcApk = new File(FileUtil.toSystemDependentName((String)srcApkPath));
        if (this.isSigned()) {
            AndroidCommonUtils.signApk((File)srcApk, (File)destFile, (PrivateKey)this.getPrivateKey(), (X509Certificate)this.getCertificate());
        } else {
            FileUtil.copy((File)srcApk, (File)destFile);
        }
    }

    private void showErrorInDispatchThread(final String message) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)ExportSignedPackageWizard.this.getProject(), (String)("Error: " + message), (String)CommonBundle.getErrorTitle());
            }
        }, ModalityState.NON_MODAL);
    }

    public void setGradleSigningInfo(GradleSigningInfo gradleSigningInfo) {
        this.myGradleSigningInfo = gradleSigningInfo;
    }
}

